/*
 * $Id: group.h,v 1.6 2003/08/25 21:04:11 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __HAPLO_FEM_GROUP_H__
#define __HAPLO_FEM_GROUP_H__

#include <haplo/module.h>

#include <fem/meshing.h>

__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                               F E M_ G R O U P _ T
-----------------------------------------------------------------------------*/

typedef void fem_group_t;


/*-----------------------------------------------------------------------------
                                P R O T O T Y P E S
-----------------------------------------------------------------------------*/

__haplo_type_display
void fem_group_display(const fem_group_t *group);

__haplo_type_copy
fem_group_t *fem_group_copy(const fem_group_t *group);

__haplo_type_free
void fem_group_free(fem_group_t *group);

__haplo_function(print)
void fem_group_print(const fem_group_t *group);

__haplo_function(group_mesh)
fem_group_t *fem_group_new_mesh(
	__haplo_protected const fem_meshing_t *meshing);

__haplo_function(group_node)
fem_group_t *fem_group_new_node(
	__haplo_protected const fem_meshing_t *meshing);

__haplo_function(add)
void fem_group_add(fem_group_t *group, haplo_list_t *list);


__haplo_function(group)
fem_group_t *fem_group_load(
	__haplo_protected const fem_meshing_t *meshing, const char *filename);


__haplo_function(group_inline)
fem_group_t *fem_group_inline(
	__haplo_protected const fem_meshing_t *meshing);


__haplo_function(save)
void fem_group_save(const char *filename, const fem_group_t *group);

__HAPLO_END_DECLS

#endif /* __HAPLO_FEM_GROUP_H__ */

