/*
 * $Id: material.h,v 1.3 2003/03/29 13:32:11 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#ifndef __HAPLO_FEM_MATERIAL_H__
#define __HAPLO_FEM_MATERIAL_H__

#include <haplo/module.h>

__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                      F E M _ M A T E R I A L _ C A R A _ T
-----------------------------------------------------------------------------*/

typedef enum fem_material_cara_
{
	HAPLO_E=0,
	HAPLO_nu,
	HAPLO_rho
} fem_material_cara_t;


/*-----------------------------------------------------------------------------
                            F E M _ M A T E R I A L  _ T
-----------------------------------------------------------------------------*/

typedef void fem_material_t;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P  E S
-----------------------------------------------------------------------------*/

__haplo_function(material)
extern fem_material_t *fem_material_new(void);

__haplo_type_copy
extern fem_material_t *fem_material_copy(const fem_material_t *material);

__haplo_type_free
extern void fem_material_free(fem_material_t *material);

__haplo_function(print)
extern void fem_material_print(const fem_material_t *material);

__haplo_function(set)
extern void fem_material_cara_set(fem_material_t *material, const char *name,
				  const double *value);

__haplo_function(unset)
extern void fem_material_cara_unset(fem_material_t *material,
				    const char *name);

__haplo_function(get)
extern double *fem_material_cara_get(const fem_material_t *material,
				     const char *c);


__HAPLO_END_DECLS

#endif /* __HAPLO_FEM_MODEL_H__ */
