/*
 * $Id: model.h,v 1.9 2003/08/30 13:27:26 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#ifndef __HAPLO_FEM_MODEL_H__
#define __HAPLO_FEM_MODEL_H__

#include <haplo/module.h>

#include <fem/material.h>
#include <fem/meshing.h>
#include <fem/property.h>


__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                            F E M _ M O D E L _ T
-----------------------------------------------------------------------------*/

typedef void fem_model_t;


/*-----------------------------------------------------------------------------
                        F E M _ M O D E L _ T Y P E _ T
-----------------------------------------------------------------------------*/

typedef enum fem_model_type_t
{
	FEM_MODEL_MECANIC
} fem_model_type_t;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P  E S
-----------------------------------------------------------------------------*/

__haplo_function(model)
extern fem_model_t *fem_model_new(
	__haplo_protected const fem_meshing_t *meshing);

__haplo_type_free
extern void fem_model_free(fem_model_t *model);

__haplo_type_display
extern void fem_model_display(const fem_model_t *model);

__haplo_type_copy
extern fem_model_t *fem_model_copy(const fem_model_t *model);

__haplo_function(print)
extern void fem_model_print(const fem_model_t *model);

__haplo_function(set)
extern void fem_model_set_material(fem_model_t *model,
				   const fem_material_t *material);

__haplo_function(set)
extern void fem_model_set_property(fem_model_t *model,
				   const fem_property_t *property);

__haplo_function(meshing)
extern fem_meshing_t *fem_model_meshing(const fem_model_t *model);

__HAPLO_END_DECLS

#endif /* __HAPLO_FEM_MODEL_H__ */

