/*
 * $Id: problem.h,v 1.2 2003/12/01 09:50:16 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __HAPLO_FEM_PROBLEM__
#define __HAPLO_FEM_PROBLEM__

#include <haplo/module.h>

#include <fem/bc.h>
#include <fem/load.h>
#include <fem/matrix.h>
#include <fem/model.h>

__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                          F E M _ P R O B L E M _ T
-----------------------------------------------------------------------------*/

typedef void fem_problem_t;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P  E S
-----------------------------------------------------------------------------*/

__haplo_type_free
extern void fem_problem_free(fem_problem_t *problem);

__haplo_type_display
extern void fem_problem_display(const fem_problem_t *problem);

__haplo_type_copy
extern fem_problem_t *fem_problem_copy(const fem_problem_t *problem);

__haplo_function(problem)
extern fem_problem_t *fem_problem_new(
	__haplo_protected const fem_model_t *model,
	__haplo_protected const fem_bc_t *bc, 
	__haplo_protected const fem_load_t *load);

__haplo_function(stiffness)
fem_matrix_t *fem_problem_gsm(const fem_problem_t *problem);

__haplo_function(vector)
fem_vector_t *fem_problem_vector(const fem_problem_t *problem);

__haplo_function(dof)
extern double *fem_problem_dof_n(const fem_problem_t *probem);

__haplo_function(dof)
extern char *fem_problem_dof_get_local(const fem_problem_t *problem,
				       const double *dof);

__haplo_function(dof)
extern double *fem_problem_dof_get_global(const fem_problem_t *problem,
				   const double *node, const char *name);


__HAPLO_END_DECLS

#endif /* __HAPLO_FEM_PROBLEM__ */
