/*
 * $Id: property.h,v 1.4 2003/03/29 13:32:12 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#ifndef __HAPLO_FEM_PROPERTY_H__
#define __HAPLO_FEM_PROPERTY_H__

#include <haplo/module.h>

__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                      F E M _ P R O P E R T Y _ C A R A _ T
-----------------------------------------------------------------------------*/

typedef enum fem_property_cara_
{
	HAPLO_S=0
} fem_property_cara_t;


/*-----------------------------------------------------------------------------
                            F E M _ P R O P E R T R Y  _ T
-----------------------------------------------------------------------------*/

typedef void fem_property_t;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P  E S
-----------------------------------------------------------------------------*/

__haplo_function(property)
extern fem_property_t *fem_property_new(void);

__haplo_type_copy
extern fem_property_t *fem_property_copy(const fem_property_t *property);

__haplo_type_free
extern void fem_property_free(fem_property_t *property);

__haplo_function(print)
extern void fem_property_print(const fem_property_t *property);

__haplo_function(set)
extern void fem_property_cara_set(fem_property_t *property, const char *name,
				  const double *value);

__haplo_function(unset)
extern void fem_property_cara_unset(fem_property_t *property,
				    const char *name);

__haplo_function(get)
extern double *fem_property_cara_get(const fem_property_t *property,
				     const char *c);


__HAPLO_END_DECLS

#endif /* __HAPLO_FEM_PROPERTY_H__ */
