/*
 * $Id: element.h,v 1.10 2003/08/25 20:56:18 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __FEM_ELEMENT_H__
#define __FEM_ELEMENT_H__

#include <fem/element.h>

struct element_type_t;
struct element_t;

/*-----------------------------------------------------------------------------
                         E L E M E N T _ T Y P E _ T 
-----------------------------------------------------------------------------*/

#include "dof.h"
#include "integration.h"
#include "hook.h"
#include "model.h"

typedef struct element_type_t
{
	fem_model_type_t	type;
	const char 		*name;
	unsigned short		nb_node;
	unsigned short		nb_dof;
	unsigned short		dim;
	dofset_t		dofset;
	const integration_t	*integration;
	const double		**x;
	hook_t			hook;		/* Buffer */
	fem_eval_j_t		j;
	fem_eval_esm_t		esm;	
	struct element_type_t	*next;
} element_type_t;


/*-----------------------------------------------------------------------------
                              E L E M E N T _ T 
-----------------------------------------------------------------------------*/

#include "material.h"
#include "meshing.h"
#include "property.h"
typedef struct element_t
{
	const mesh_t			*mesh;
	const property_t		*property;
	const struct element_type_t	*type;
	const material_t		*material;
} element_t;	  


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

#include "matrix.h"
#include "numbering.h"

extern void __fem_element_type_free(void);
extern element_t *__fem_element_create(const meshing_t *meshing);

extern void __fem_element_gsm_profile(matrix_t *gsm, const element_t *element,
				      unsigned long el,
				      const numbering_t *numbering);

extern void __fem_element_gsm_compute(matrix_t *gsm, const element_t *element,
				      unsigned long el,
				      const numbering_t *numbering);

#endif /* __FEM_ELEMENT_H__ */
