/*
 * $Id: group.h,v 1.4 2003/08/25 20:53:52 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#ifndef __FEM_GROUP_H__
#define __FEM_GROUP_H__

#include <fem/group.h>

#include "meshing.h"
#include "page.h"


/*-----------------------------------------------------------------------------
                           G R O U P _ T Y P E _ T 
-----------------------------------------------------------------------------*/

typedef enum group_type_t
{
	GROUP_MESH,
	GROUP_NODE
		
} group_type_t;


/*-----------------------------------------------------------------------------
                                G R O U P _ T 
-----------------------------------------------------------------------------*/

typedef struct group_t
{
	const meshing_t	*meshing;
	group_type_t	type;
	page_list_t	list;
} group_t;


/*-----------------------------------------------------------------------------
                           G R O U P _ F U N C _ T 
-----------------------------------------------------------------------------*/

typedef void (*group_func_t)(void *);


/*-----------------------------------------------------------------------------
                         G R O U P _ F U N C _ P _ T
-----------------------------------------------------------------------------*/

typedef void (*group_func_p_t)(void *, void *);


/*-----------------------------------------------------------------------------
                                 M A C R O S 
-----------------------------------------------------------------------------*/

#define GROUP(x)		((group_t *)(x))   


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

extern void __fem_group_mesh_loop(const group_t *group, group_func_t f);
extern void __fem_group_mesh_loop_p(const group_t *group, group_func_p_t f,
				    void *p);
extern void __fem_group_node_loop(const group_t *group, group_func_t f);
extern void __fem_group_node_loop_p(const group_t *group, group_func_p_t f,
				    void *p);

#endif /* __FEM_GROUP_H__ */

