/*
 * $Id: load.h,v 1.4 2003/10/05 20:03:48 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#ifndef __FEM_LOAD_H__
#define __FEM_LOAD_H__

#include <fem/load.h>

#include "dof.h"
#include "numbering.h"
#include "page.h"


/*-----------------------------------------------------------------------------
                            L O A D _ T Y P E _ T
-----------------------------------------------------------------------------*/

typedef enum load_type_t
{
	LOAD_NODE,
	LOAD_MESH
} load_type_t;


/*-----------------------------------------------------------------------------
                                 L O A D _ T 
-----------------------------------------------------------------------------*/

typedef struct load_t
{
	load_type_t	type;		/* kind of load */
	unsigned long	n;		/* node or mesh number */
	dofset_t	dof;		/* direction */
	double		value;		/* module */
} load_t;



typedef struct load_list_t
{
	page_list_t	load;
} load_list_t;


/*-----------------------------------------------------------------------------
                                 M A C R O S 
----------------------------------------------------------------------------*/

#define LOAD_LIST(x) ((load_list_t *)(x))


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

dofset_t __fem_load_nb(const char *name);
extern void __fem_load_vector(vector_t *b, const load_list_t *load,
			      const numbering_t *numbering,
			      const meshing_t *meshing);

#endif /* __FEM_LOAD_H__ */
