/*
 * $Id: meshing.h,v 1.11 2003/10/13 09:24:14 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#ifndef __FEM_MESHING_H__
#define __FEM_MESHING_H__

#include <stdio.h>

#include <fem/meshing.h>

#include "page.h"


/*-----------------------------------------------------------------------------
                           N O D E _ L I S T _ T
-----------------------------------------------------------------------------*/

typedef struct node_list_t
{
	page_list_t		nodes;
	unsigned short		dim;		/* dimension de l'espace */
} node_list_t;


/*-----------------------------------------------------------------------------
                                 N O D E _ T
-----------------------------------------------------------------------------*/

#define STRUCT_NODE(dim) struct { unsigned long n; double coords[dim]; }

typedef STRUCT_NODE(1) node_t;


/*-----------------------------------------------------------------------------
                            M E S H _ L I S T _ T
-----------------------------------------------------------------------------*/

typedef struct mesh_list_t
{
	unsigned long 		nb;
	page_list_t		meshes_2;
	page_list_t		meshes_3;
	page_list_t		meshes_4;
	page_list_t		meshes_6;
	page_list_t		meshes_8;
} mesh_list_t;

#define MESH_BIGGEST   	8
#define MESHING_APPLY(f) f(2); f(3); f(4); f(6); f(8)


/*-----------------------------------------------------------------------------
                                M E S H _ T
-----------------------------------------------------------------------------*/

#define STRUCT_MESH(nb)  struct { unsigned long n; node_t *nodes[nb]; }
typedef STRUCT_MESH(1) mesh_t;


/*-----------------------------------------------------------------------------
                              M E S H I N G _ T
-----------------------------------------------------------------------------*/

typedef struct meshing_t
{
	node_list_t	node_list;
	mesh_list_t 	mesh_list;
} meshing_t;


/*-----------------------------------------------------------------------------
                                 M A C R O S
-----------------------------------------------------------------------------*/

#define MESHING(x)	((meshing_t *)(x))
#define NB_NODES(x) 	((x)->node_list.nodes.nb)
#define NB_MESHES(x)	((x)->mesh_list.nb)


/*-----------------------------------------------------------------------------
                         M E S H I N G _ F U N C _ T
-----------------------------------------------------------------------------*/

typedef void (*meshing_func_p_t)(mesh_t *, unsigned short, void *);


/*-----------------------------------------------------------------------------
                              P R O T O T Y P E S
-----------------------------------------------------------------------------*/

extern node_t *__fem_node_get(const meshing_t *meshing, unsigned long n);
extern unsigned long __fem_node_internal(const meshing_t *meshing,
					 unsigned long n);
extern unsigned long __fem_node_user(const meshing_t *meshing,
				     unsigned long n);
extern mesh_t *__fem_mesh_get(const meshing_t *meshing, unsigned long n);
extern int __fem_meshing_load_header(FILE *fp, int *line);
extern void __fem_meshing_loop_p(const meshing_t *meshing,
				 meshing_func_p_t f,
				 void *data);
#endif /* __FEM_MESHING_H__ */
