/*
 * $Id: problem.h,v 1.1 2003/08/30 13:31:29 nicoo Exp $
 *
 *
 * Copyright (C) 1999-2003 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __FEM_PROBLEM_H__
#define __FEM_PROBLEM_H__

#include <fem/problem.h>

#include "bc.h"
#include "load.h"
#include "model.h"
#include "numbering.h"

typedef struct problem_t
{
	const bc_list_t		*bc_list;
	const load_list_t 	*load_list;
	const model_t		*model;
	numbering_t		numbering;
	double			beta;		/* Boundary condition factor */
} problem_t;

#define PROBLEM(x)	((problem_t *)(x))


#endif /* __FEM_PROBLEM_H__ */
