# happydigger.spec
#
# Copyright (c) 2004, 2005 Joop Stakenborg pg4i@amsat.org
#
%define name happydigger
%define version 2.1
%define release 1

# required items
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
Group: Applications/Databases
Prefix: /usr
BuildRoot: /var/tmp/%{name}-%{version}
Summary: Program for cataloging for archaeological finds
Vendor: Joop Stakenborg <pg4i@amsat.org>
URL: http://www.xs4all.nl/~pa4tu/happydigger
Packager: Joop Stakenborg <pg4i@amsat.org>
Source: %{name}-%{version}.tar.gz

%description
Happydigger is a program which you can be used for cataloging archaeological
finds. It is intended both for semi-professional use and by amateurs (e.g.
metal detectorists) who want to keep track of their finds.

Data is stored into a database with extensive find and findspot details.
If images are available, they will be displayed together with the find
information.

%prep
%setup -q

%build
%configure
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ChangeLog

/usr/bin/happydigger
/usr/share/locale/nl/LC_MESSAGES/happydigger.mo
/usr/share/locale/fr/LC_MESSAGES/happydigger.mo
/usr/share/locale/sv/LC_MESSAGES/happydigger.mo
/usr/share/locale/tl/LC_MESSAGES/happydigger.mo
/usr/share/happydigger/pixmaps/*
/usr/share/happydigger/README
/usr/share/happydigger/LEESMIJ
/usr/share/happydigger/LISEZ-MOI
/usr/share/man/man1/happydigger.1.gz
/usr/share/applications/happydigger.desktop
/usr/share/pixmaps/happydigger.png

%changelog
* Sat Apr 03 2004 Joop Stakenborg
- Initial spec file
