;;; tts-assist.el -- functions that assist `parser' from tts.el

;; Copyright (C) 2005 Joe Corneli <jcorneli@math.utexas.edu>

;; Time-stamp: <jac -- Sun Jun 26 10:12:58 CDT 2005>

;; This file is not part of GNU Emacs, but it is distributed under
;; the same terms as GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary

;;; Code:

(require 'tts-utils)

(defun parser-one-token-case ()
  (setq tree (or (operator (car tokens))
                 (modifier (car tokens))
                 (greedy-operator (car tokens))
                 (number (car tokens))
                 (intern (car tokens)))))

(defun parser-paren-case ()
  (let ((retval (parse-parens tokens tree waiting)))
    (setq waiting
          (basic-waiting-builder 
           waiting parens t (first retval)))
    (setq tree (parser (second retval) tree waiting 'group))))

(defun parser-operator-case ()
  (if waiting
      (setq tree (list (operator (car tokens))
                       waiting
                       ;; we no longer have anything waiting
                       ;; (in this simple model!)
                       (parser (cdr tokens) tree nil)))
    (setq tree (list (operator (car tokens))
                     (parser (cdr tokens) tree nil)))))

(defun parser-negative-number-case ()
  (setq waiting (if waiting
                    (append (list waiting)
                            (list (- (string-to-number
                                      (second tokens)))))
                  (-  (string-to-number(second tokens))))
        tree (parser (nthcdr 2 tokens) tree waiting)))

(defun parser-modifier-case ()
  (let ((modified (parser-1 (cdr tokens))))
    (setq waiting (list (modifier (car tokens))
                        (car modified))
          tokens (second modified)
          tree (parser tokens tree waiting))))

(defun parser-function-property-case ()
  (let ((retval (parse-function-def tokens waiting)))
    (setq waiting (car retval)
          tokens (second retval)
          tree (parser tokens tree waiting))))

(defun parser-quantifier-case ()
  (setq tree (parse-quantifier tokens)))

(defun parser-summation-case ()
  (setq tree (basic-waiting-builder waiting
                                    parens
                                    nil
                                    (parse-summation tokens))))

(defun parser-default-case ()
  (let (current)
    (when (and waiting
               (listp waiting)
               (eq (car waiting) '*~))
      (setq current '*~))
    (let ((next (parser-1 tokens current)))
      (setq waiting (basic-waiting-builder waiting
                                           parens
                                           (third next)
                                           (first next))
            tokens (second next)
            tree (parser tokens tree waiting (third next))))))

(provide 'tts-assist)

;;; tts-assist.el ends here