;;; tts-utils.el -- basic stuff to help with parsing

;; Copyright (C) 2005 Joe Corneli <jcorneli@math.utexas.edu>

;; Time-stamp: <jac -- Sun Jun 26 10:15:53 CDT 2005>

;; This file is not part of GNU Emacs, but it is distributed under
;; the same terms as GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary

;;; Code:

(defun require-append (head tail)
  (unless (listp head)
    (setq head (list head)))
  (unless (listp tail)
    (setq tail (list tail)))
  (append head tail))

(defun require-list (item)
  (if (listp item)
      item
    (list item)))

(defun protect-list (item)
  (if (listp item)
      item
    (list item)))

(defun parser-reloaded ()
  (interactive)
  (eval-buffer (get-buffer "tts.el"))
  (eval-buffer (get-buffer "tts-assist.el"))
  (eval-buffer (get-buffer "tts-continuation.el")))

(provide 'tts-utils)

;;; tts-utils.el ends here

;;; tts-utils.el ends here