<?
/*
 *   This file is part of The Horus Indexer.
 *
 *   The Horus Indexer is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   The Horus Indexer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with The Horus Indexer; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
********************************************************************************
 * Copyright (c) 2005 Jorge Barrera Grandon
 *
 */

function hsc($string){
  return htmlspecialchars($string);
}

function cleanpath($path){
  $path = preg_replace('#//#','/',$path);
  $path = preg_replace('#^/#','',$path);
  $path = preg_replace('#/$#','',$path);
  $path = preg_replace('#\.\.+#','',$path);
  return $path;
}

function geshitype($file){
  global $conf;
  preg_match('/\.([\w]+?)$/',$file,$matches);
  $ext = strtolower($matches[1]);
  return $conf['geshi'][$ext];
}

function texttype($file){
  if(preg_match('#^(README|COPYING|INSTALL|AUTHORS|Makefile|Changelog|TODO|VERSION)$#',basename($file)) ||
     preg_match('#\.txt$#i',$file)){
    return true;
  }
  return false;
}

function imagetype($file){
  preg_match('/\.([\w]+?)$/',$file,$matches);
  $ext = strtolower($matches[1]);
  if($ext == 'png'){
    return 'image/png';
  }elseif($ext == 'gif'){
    return 'image/gif';
  }elseif($ext == 'jpg' || $ext == 'jpeg'){
    return 'image/jpg';
  }
  return '';
}

/**
 * Return the human readable size of a file
 *
 * @param       int    $size   A file size
 * @param       int    $dec    A number of decimal places
 * @author      Martin Benjamin <b.martin@cybernet.ch>
 * @author      Aidan Lister <aidan@php.net>
 * @version     1.0.0
 */
function filesize_h($size, $dec = 1)
{
  $sizes = array('B', 'KB', 'MB', 'GB');
  $count = count($sizes);
  $i = 0;
    
  while ($size >= 1024 && ($i < $count - 1)) {
    $size /= 1024;
    $i++;
  }

  return round($size, $dec) . ' ' . $sizes[$i];
}

function read_descript_ion($file){
  $lines = file($file);
  $descs = array();
  foreach($lines as $line){
    $line = trim($line);
    $d = ''; $f = '';
    #handle quoted and unquoted filenames
    if(preg_match('/^"(.*?)"\s+(\S.*)$/',$line,$matches)){
      $f = $matches[1];
      $d = $matches[2];
    }else{
      list($f,$d) = preg_split('/\s+/',$line,2);
    }
    if($f && $d) $descs[$f]=$d;
  }
  return($descs);
}


/**
 * Returns the full absolute URL to the directory where
 * Horus is installed in (includes a trailing slash)
 *
 * @author Andreas Gohr <andi@splitbrain.org>
 */    
function getBaseURL($abs=true){
  global $conf;

  if($_SERVER['SCRIPT_NAME']){
    $dir = dirname($_SERVER['SCRIPT_NAME']).'/';
  }elseif($_SERVER['DOCUMENT_ROOT'] && $_SERVER['SCRIPT_FILENAME']){
    $dir = preg_replace ('/^'.preg_quote($_SERVER['DOCUMENT_ROOT'],'/').'/','',
                         $_SERVER['SCRIPT_FILENAME']);
    $dir = dirname('/'.$dir).'/';
  }else{
    $dir = dirname($_SERVER['PHP_SELF']).'/';
  }

  $dir = str_replace('\\','/',$dir); #bugfix for weird WIN behaviour
  $dir = preg_replace('#//+#','/',$dir);

  //finish here for relative URLs
  if(!$abs) return $dir;

  $port = ':'.$_SERVER['SERVER_PORT'];
  //remove port from hostheader as sent by IE
  $host = preg_replace('/:.*$/','',$_SERVER['HTTP_HOST']);

  // see if HTTPS is enabled - apache leaves this empty when not available,
  // IIS sets it to 'off', 'false' and 'disabled' are just guessing
  if (preg_match('/^(|off|false|disabled)$/i',$_SERVER['HTTPS'])){
    $proto = 'http://';
    if ($_SERVER['SERVER_PORT'] == '80') {
      $port='';
    }
  }else{
    $proto = 'https://';
    if ($_SERVER['SERVER_PORT'] == '443') {
      $port='';
    }
  }

  return $proto.$host.$port.$dir;
}

?>
