#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

# The format of the user configuration file is to be determined.

import hsh.content

from hsh.exceptions import *
from displayable import CursesDisplayable

class CursesMessage(CursesDisplayable):

    def __init__(self, display, message, face="default"):
        super(CursesMessage, self).__init__(display)
        self.face = face
        self._set_message(message)

    def _set_message(self, message):
        self.content = hsh.content.TextContent()
        for line in message.split('\n'):
            r = self.content.append_region(line + '\n')
            r.face = self.display.faces[self.face]

    def set_message(self, message):
        self._set_message(message)
        self.draw()
