#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

class HshDisplay(object):
    """An interface which needs to be implemented by specific displays.  The
    main display object, hsh.display_obj is an HshDisplay, usable by all other
    objects."""

    def show_alert(self, message):
        """Show a simple alert message to the user."""
        pass

    def get_visible_job(self):
        """Return whichever job the user would think is the current one, based
        on the visible display."""
        pass

    def show_view(self, view_name):
        """Show the view of the given name to the user."""
        pass

    def list_views(self):
        """Return a list of view names."""
        return []
