-- 
-- Home Site Maker, the websites factory.
-- Copyright (C) 2004, 2005 Marcos Martinez Jimenez
--
-- This file is part of Home Site Maker.
--
--     Home Site Maker is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     Home Site Maker is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
-- 
--     You should have received a copy of the GNU General Public License
--     along with Home Site Maker; see the file COPYING. If not, write to the Free Software
--     Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
--
--
-- Marcos Martinez Jimenez
-- marcos@assl-site.net
-- http://homesitemaker.no-ip.org
-- Francesc Llunell n 1 4 5, Esplugues de Llobregat, 08950 Barcelona, Spain
-- 


--
-- Table structure for table `album`
--

CREATE TABLE `album` (
  `id_album` mediumint unsigned NOT NULL auto_increment,
  `id_author` mediumint unsigned default NULL,
  `section` varchar(6) default NULL,
  `title` varchar(128) default NULL,
  `description` varchar(255) default 'No description available due to the user was too lazy to put one.',
  `allow_to_see` enum('all','users','list') default 'all',
  `allow_to_add` enum('all','users','list') default 'all',
  `edited` datetime NOT NULL default '0000-00-00 00:00:00',
  `posted` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_album`)
) TYPE=MyISAM; 




--
-- Table structure for table `album_allow_to_add_list`
--

CREATE TABLE `album_allow_to_add_list` (
  `id_album` mediumint unsigned NOT NULL default '0',
  `id_user` mediumint unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id_album`,`id_user`),
  KEY `id_` (`id_album`,`id_user`)
) TYPE=MyISAM; 




--
-- Table structure for table `album_allow_to_see_list`
--

CREATE TABLE `album_allow_to_see_list` (
  `id_album` mediumint unsigned NOT NULL default '0',
  `id_user` mediumint unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id_album`,`id_user`),
  KEY `id_` (`id_album`,`id_user`)
) TYPE=MyISAM; 




--
-- Table structure for table `comment`
--

CREATE TABLE `comment` (
  `id_comment` smallint unsigned NOT NULL auto_increment,
  `id_info` mediumint unsigned default NULL,
  `id_author` mediumint unsigned default NULL,
  `father_comment` smallint unsigned default NULL,
  `title` varchar(128) default NULL,
  `body_text` text,
  `text_type` varchar(4) default 'text',
  `posted` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id_comment`)
) TYPE=MyISAM; 




--
-- Table structure for table `diary`
--

CREATE TABLE `diary` (
  `id_diary` mediumint unsigned NOT NULL auto_increment,
  `id_author` mediumint unsigned default NULL,
  `section` varchar(6) default NULL,
  `event_title` varchar(128) default NULL,
  `event_type` varchar(50) default NULL,
  `event_place` varchar(30) default NULL,
  `description` text,
  `event_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id_diary`)
) TYPE=MyISAM; 




--
-- Table structure for table `info`
--

CREATE TABLE `info` (
  `id_info` mediumint unsigned NOT NULL auto_increment,
  `id_author` mediumint unsigned default NULL,
  `modified_by` varchar(30) default NULL,
  `section` varchar(6) default NULL,
  `headline` varchar(128) default NULL,
  `topic` varchar(30) default NULL,
  `intro_text` text,
  `body_text` text,
  `text_type` varchar(4) default 'text',
  `attached_photos` char(3) default 'NO',
  `use_intro` char(3) default 'NO',
  `edited` datetime NOT NULL default '0000-00-00 00:00:00',
  `posted` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_info`)
) TYPE=MyISAM; 

--
-- Dumping data for table `info`
--


INSERT INTO `info` VALUES (2,1,'admin','TAB_12','Headline Tab 1 Section 2','topic1.png','','Maybe you want edit this text','text','NO','NO','2004-12-21 21:16:13','2004-11-09 22:12:39',2),(3,1,'admin','TAB_13','Headline Tab 1 Section 3','topic1.png','','Maybe you want edit this text','text','NO','NO','2004-12-21 21:17:47','2004-11-09 22:12:39',2),(4,1,'admin','TAB_14','Headline Tab 1 Section 4','topic1.png','','Maybe you want edit this text','text','NO','NO','2003-05-07 12:00:00','2004-11-09 22:12:39',2),(5,1,'admin','TAB_21','Headline Tab 2 Section 1','topic1.png','','Maybe you want edit this text','text','NO','NO','2004-12-21 21:16:48','2004-11-09 22:12:39',2),(6,1,'admin','TAB_22','Headline Tab 2 Section 2','topic1.png','','Maybe you want edit this text','text','NO','NO','2004-12-21 21:17:06','2004-11-09 22:12:39',2),(7,1,'admin','TAB_23','Headline Tab 2 Section 3','topic1.png','','Maybe you want edit this text','text','NO','NO','2003-05-07 12:00:00','2004-11-09 22:12:39',2),(8,1,'admin','TAB_24','Headline Tab 2 Section 4','topic1.png','','Maybe you want edit this text','text','NO','NO','2003-05-07 12:00:00','2004-11-09 22:12:39',2),(9,1,'admin','TAB_31','Headline Tab 3 Section 1','topic1.png','','Maybe you want edit this text','text','NO','NO','2003-05-07 12:00:00','2004-11-09 22:12:39',2),(10,1,'admin','TAB_32','Headline Tab 3 Section 2','topic1.png','','Maybe you want edit this text','text','NO','NO','2003-05-07 12:00:00','2004-11-09 22:12:39',2),(11,1,'admin','TAB_33','Headline Tab 3 Section 3','topic1.png','','Maybe you want edit this text','text','NO','NO','2003-05-07 12:00:00','2004-11-09 22:12:39',2),(12,1,'admin','TAB_34','Headline Tab 3 Section 4','topic1.png','','Maybe you want edit this text','text','NO','NO','2003-05-07 12:00:00','2004-11-09 22:12:39',2),(13,1,'admin','TAB_41','Headline Tab 4 Section 1','topic1.png','','Maybe you want edit this text','text','NO','NO','2004-12-21 21:17:24','2004-11-09 22:12:39',2),(14,1,'admin','TAB_42','Headline Tab 4 Section 2','topic1.png','','Maybe you want edit this text','text','NO','NO','2004-12-21 21:17:36','2004-11-09 22:12:39',2),(15,1,'admin','TAB_43','Headline Tab 4 Section 3','topic1.png','','Maybe you want edit this text','text','NO','NO','2003-05-07 12:00:00','2004-11-09 22:12:39',2),(16,1,'admin','TAB_44','Headline Tab 4 Section 4','topic1.png','','Maybe you want edit this text','text','NO','NO','2003-05-07 12:00:00','2004-11-09 22:12:39',2);

--
-- Table structure for table `info_album`
--

DROP TABLE IF EXISTS `info_album`;
CREATE TABLE `info_album` (
  `id_info` mediumint unsigned NOT NULL default '0',
  `id_photo` tinyint(8) unsigned NOT NULL auto_increment,
  `filename` char(128) default NULL,
  `height` char(4) default NULL,
  `width` char(4) default NULL,
  PRIMARY KEY  (`id_info`,`id_photo`),
  KEY `id_` (`id_info`,`id_photo`)
) TYPE=MyISAM; 




--
-- Table structure for table `photo_album`
--

DROP TABLE IF EXISTS `photo_album`;
CREATE TABLE `photo_album` (
  `id_album` mediumint unsigned NOT NULL default '0',
  `id_photo` tinyint(8) unsigned NOT NULL auto_increment,
  `id_author` mediumint unsigned NOT NULL default '0',
  `filename` varchar(128) default NULL,
  `description` varchar(255) default 'No description available due to the user was too lazy to put one.',
  `posted` datetime NOT NULL default '0000-00-00 00:00:00',
  `height` varchar(4) default NULL,
  `width` varchar(4) default NULL,
  PRIMARY KEY  (`id_album`,`id_photo`),
  KEY `id_` (`id_album`,`id_photo`)
) TYPE=MyISAM; 




--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id_user` mediumint unsigned NOT NULL auto_increment,
  `nick` char(16) NOT NULL default '',
  `password` char(16) default NULL,
  `email` char(64) default NULL,
  `real_name` char(64) default NULL,
  `user_photo_file` char(255) default 'photos/users/anonymous.jpg',
  `level` int(2) default '0',
  PRIMARY KEY  (`id_user`)
) TYPE=MyISAM; 

--
-- Dumping data for table `users`
--


INSERT INTO `users` VALUES (1,'anonymous','','','Anonymous User','photos/users/anonymous.jpg',0),(2,'admin','zzbjDDQTdDywk','your_email_address@yourdomain','Your full name','photos/users/anonymous.jpg',99);

