<?php 

/*
Home Site Maker, the websites factory.
Copyright (C) 2004, 2005 Marcos Martinez Jimenez

This file is part of Home Site Maker.

    Home Site Maker is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Home Site Maker is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Home Site Maker; see the file COPYING. If not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


Marcos Martinez Jimenez
marcos@assl-site.net
http://homesitemaker.no-ip.org
Francesc Llunell n 1 4 5, Esplugues de Llobregat, 08950 Barcelona, Spain
*/


// FILENAME: graph_functions
// DESCRIPTION: Some functions used to resize upload images and more.

function check_upload_max_filesize ($filename){
global $LANGUAGE;
include ("includes/languages/".$LANGUAGE."/homesite-includes-graph_functions.php");
$upload_max_filesize=ini_get('upload_max_filesize');
$filesize=$_FILES['userfile']['size'][0];
if (!empty($filename) && ($filesize == 0 )) // Depending on the php.ini settings your photo could be too big
   {
    echo "<div class=\"alert\" align=\"center\">$TEXT001 $upload_max_filesize<br><br></div>";
   }
}

function resize_image ($path_photo,$new_width, $new_height, $path_resized_photo){
global $LANGUAGE;
include ("includes/languages/".$LANGUAGE."/homesite-includes-graph_functions.php");
$filename=basename($path_photo);
$size=getimagesize($path_photo);
$width=$size[0];
$height=$size[1];
$image_format=$size[2]; // getimagesize returns IMAGETYPE_XXX (IMAGETYPE_GIF | IMAGETYPE_JPEG | IMAGETYPE_PNG)
                        // depending on the image type detected.
                        // imagetypes () return  IMG_XXX (IMG_GIF | IMG_JPG | IMG_PNG | IMG_WBMP | IMG_XPM)
                        // depending on the formats supported by the server.
                        // The $allowed_formats array has the formats supported by the server using the fromat IMAGETYPE_XXX
$n=0;
if (imagetypes () & IMG_PNG) {$allowed_formats[$n]=IMAGETYPE_GIF;$n++;}
if (imagetypes () & IMG_GIF) {$allowed_formats[$n]=IMAGETYPE_JPEG;$n++;}
if (imagetypes () & IMG_JPG) {$allowed_formats[$n]=IMAGETYPE_PNG;$n++;}
foreach ($allowed_formats as $format ){if($image_format == $format) $supported_format=1;}
if ($supported_format)
{
// create a thumbnail image with the maximum width, or height, of 200 pixels if one of the values are bigger than 200 pixels.
if ( ($height >= $new_height) || ($width >= $new_width)  )
   {
   $w=$new_width; $h=$new_height;
   if ($width > $height) 
      {
      $h_thumb=($w*$height)/$width;
      $w_thumb=$w;
      } else {
              $w_thumb=($h*$width)/$height;
              $h_thumb=$h;
              }
      $thumb = imagecreatetruecolor($w_thumb, $h_thumb);
      //The imagecreatefromXXX() function can die unexpectedly if we don't have enough reserved memory. 
      //The following code tries to allocate the required memory dynamically.
      //$required_memory = Round(($width * $height * $size['bits'] * $size['channels'] / 8 + 65536) * 1.8);
     switch ($image_format) {
            case IMAGETYPE_GIF:
                 $required_memory = Round($size['bits']*2);
                 break;
            case IMAGETYPE_JPEG:
                 $required_memory = Round(($width * $height * $size['bits'] * $size['channels'] / 8 + 65536) * 1.8);
                 break;
            case IMAGETYPE_PNG:
                 $required_memory = Round($width * $height * $size['bits'] + 1048576);
                 break;
                 }

     $php_ini_memory_limit=rtrim(ini_get('memory_limit'),'M') * 1048576;

     if (function_exists('memory_get_usage') && (memory_get_usage() + $required_memory) > $php_ini_memory_limit )
        {
        $new_limit = 8 + ceil( ( memory_get_usage() + $required_memory - 8388608) / 1048576);
        $new_limit = $new_limit.'M';
        ini_set("memory_limit", $new_limit);
        }
     switch ($image_format) {
           case IMAGETYPE_GIF:
                $source = imagecreatefromgif($path_photo);
                imagecopyresampled($thumb, $source, 0, 0, 0, 0, $w_thumb, $h_thumb, $width, $height);
                imagegif($thumb,$path_resized_photo);
                break;
           case IMAGETYPE_JPEG:
                $source = imagecreatefromjpeg($path_photo);
                imagecopyresampled($thumb, $source, 0, 0, 0, 0, $w_thumb, $h_thumb, $width, $height);
                imagejpeg($thumb,$path_resized_photo);
                break;
           case IMAGETYPE_PNG:
                $source = imagecreatefrompng($path_photo);
                imagecopyresampled($thumb, $source, 0, 0, 0, 0, $w_thumb, $h_thumb, $width, $height);
                imagepng($thumb,$path_resized_photo);
                break;
                }
         ini_restore ("memory_limit");
     } else symlink ($filename, $path_resized_photo);
} else echo "$TEXT002<br>";
}
?>