#!/bin/bash

#    dotest.sh - checks whether zipping and unzipping restores original
#    Copyright (C) 2007 Matthew Strait
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

flags="-l 2 -n 55 -q"

while [ $1 ]; do
	md5sum "$1" > sums.$$
	cp -i "$1" "$1.orig"
        printf "zipping $1..."
	if humanzip $flags -- "$1"; then
		printf "unzipping..."
		humanunzip -k -- "$1.hz"
		printf checking...
		if md5sum -c sums.$$ &> /dev/null; then
			echo OK
			rm "$1.orig" "$1.hz"
		else
			echo 
			echo FAILED: restoring old file, saving failures as "$1.badunzip" and "$1.badhz"
			mv "$1" "$1.badunzip"
			mv "$1.hz" "$1.badhz"
			mv "$1.orig" "$1"
		fi
	fi
	shift
done

rm -f sums.$$
