/*
    humanunzip.h - common definitions for human(un)zip
    Copyright (C) 2007 Matthew Strait

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
*/

#include "humanversion.h"

struct searchreplace{
  string search;
  string replacelower;
  string replaceupper;
  unsigned int words;
  int timesused;
};

struct phrase{
  string s; // the phrase itself
  unsigned int pos; // position in the file
  unsigned int words; // length of the phrase
};

string lowerfirstletter(const string & s)
{
  string answer = s;
  if(answer.size() > 0) answer[0] = tolower(answer[0]);
  return answer;
}

string raisefirstletter(const string & s)
{
  string answer = s;
  if(answer.size() > 0) answer[0] = toupper(answer[0]);
  return answer;
}

