# $Id: icel-del.tcl 2005-01-14 16:51:37 mferra $
# Copyright (c) 2004 - Marco Ferra <mferra@sdf.lonestar.org>
# http://mferra.freeshell.org/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

proc pub:icel:del {nc hs hn ch tx} {
  global icel

  set pl [split $tx]
  set ix [lindex $pl 1]

  if {![string length $tx]} {
    puthelp "notice $nc :invalid syntax"
    return 0
  } elseif {![string is integer -strict $ix]} {
    set ix 0
  }

  if {[icel:hdb]} {
    puthelp "notice $nc :can't open database"
    return 0
  }

  set un [mysql_escape [lindex $pl 0]]

  if {$icel(cdb)} {
    if {!$ix} {
      mysql_query "DELETE FROM $icel(tbl) WHERE unit = '$un'"
    } else {
      mysql_query "DELETE FROM $icel(tbl) WHERE unit = '$un' && id = '$ix'"
    }
  } else {
    if {!$ix} {
      mysql_query "DELETE FROM $icel(tbl) WHERE unit = '$un' && chan = '$ch'"
    } else {
      mysql_query "DELETE FROM $icel(tbl) WHERE unit = '$un' && = '$ix' && chan = '$ch'"
    }
  }

  set ix [mysql_affected_rows]

  mysql_close

  if {!$ix} {
    puthelp "notice $nc :key not found"
    putlog "icel: $nc on $ch did !d $tx (not found)"
    return 0
  }

  puthelp "notice $nc :key deleted (defs: $ix)"
  putlog "icel: $nc on $ch did !d $tx (deleted)"
}
