# $Id: icel-inf.tcl 2005-01-14 16:51:37 mferra $
# Copyright (c) 2004 - Marco Ferra <mferra@sdf.lonestar.org>
# http://mferra.freeshell.org/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

proc pub:icel:inf {nc hs hn ch tx} {
  global icel

  set pl [split $tx]

  if {[icel:hdb]} {
    puthelp "notice $nc :can't open database"
    return 0
  }

  set fx "You"

  if {[string length $tx]} {
    set nc [lindex $pl 0]
    set fx "Him"
  }

  set nc [mysql_escape $nc]

  if {$icel(cdb)} {
    set ax [llength [mysql_query "SELECT * FROM $icel(tbl)"]]
    set bx [llength [mysql_query "SELECT * FROM $icel(tbl) GROUP BY unit"]]
    set cx [llength [mysql_query "SELECT * FROM $icel(tbl) WHERE nick = '$nc'"]]
    set dx [llength [mysql_query "SELECT * FROM $icel(tbl) WHERE nick = '$nc' GROUP BY unit"]]
  } else {
    set ax [llength [mysql_query "SELECT * FROM $icel(tbl) WHERE chan = '$ch'"]]
    set bx [llength [mysql_query "SELECT * FROM from $icel(tbl) WHERE chan = '$ch' GROUP BY unit"]]
    set cx [llength [mysql_query "SELECT * FROM from $icel(tbl) WHERE nick = '$nc' && chan = '$ch'"]]
    set dx [llength [mysql_query "SELECT * FROM from $icel(tbl) WHERE nick = '$nc' && chan = '$ch' GROUP BY unit"]]
  }

  mysql_close

  set ex [format "%0.2f" [expr (($cx + 0.00) * 100) / $ax]]

  puthelp "privmsg $ch :DB totals \[Keys/Defs\]: $bx/$ax.  $fx: \[Keys/Defs\]: $dx/$cx.  Contributed: $ex%"

  putlog "icel: $nc on $ch did !i $tx (done)"
}
