# $Id: icel-sch.tcl 2005-01-14 16:51:37 mferra $
# Copyright (c) 2004 - Marco Ferra <mferra@sdf.lonestar.org>
# http://mferra.freeshell.org/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

proc pub:icel:sch {nc hs hn ch tx} {
  global icel

  if {![string length $tx]} {
    puthelp "notice $nc :invalid syntax"
    return 0
  }

  if {[icel:hdb]} {
    puthelp "notice $nc :can't open database"
    return
  }

  set ax [split $tx]
  set bx [mysql_escape [lindex $ax 0]]

  set cx "defn LIKE '%$bx%' ||"
  set dx "defn LIKE '%$bx' ||"
  set ex "defn LIKE '$bx%' ||"
  set fx "unit LIKE '$bx'"

  set bx "($cx $dx $ex $fx)"

  set ax [mysql_escape [join [lrange $ax 1 end]]]

  foreach gx $ax {
    set cx "defn like '%$gx%' or"
    set dx "defn like '%$gx' or"
    set ex "defn like '$gx%' or"
    set fx "unit like '$gx'"

    set bx "$bx and ($cx $dx $ex $fx)"
  }

  if {$icel(cdb)} {
    set un [mysql_query "SELECT * FROM $icel(tbl) WHERE $bx GROUP BY unit"]
  } else {
    set un [mysql_query "SELECT * FROM $icel(tbl) WHERE $bx && chan = '$ch' GROUP BY unit"]
  }

  mysql_close

  set ix [llength $un]
  set rs [list]

  foreach nu $un {
    lappend rs [join [lrange $nu 5 5]]
  }

  if {!$ix} {
    puthelp "notice $nc :no results"
  } elseif {$ix < 32} {
    puthelp "notice $nc :found ($ix): [join $rs]"
  } else {
    puthelp "notice $nc :found ($ix): be more specific"
  }

  putlog "icel: $nc on $ch did !s $tx (done)"
}
