# $Id: icel-add.tcl 2005-01-16 14:25:05 mferra $
# Copyright (C) 2004 - Marco Ferra <mferra@sdf.lonestar.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


proc pub:icel:add {nc hs hn ch tx} {
  global icel

  set pl [split $tx]

  if {![string length [lindex $pl 1]]} {
    puthelp "notice $nc :invalid syntax"
    return 0
  } elseif {[string length [lindex $pl 0]] > $icel(uls)} {
    puthelp "notice $nc :invalid size for unit (+ $icel(uls) chars)"
    putlog "icel: $nc on $ch did !a $tx (key too long)"
    return 0
  }

  if {[icel:hdb]} {
    puthelp "notice $nc :can't open database"
    return 0
  }

  set un [mysql_escape [lindex $pl 0]]

  if {[llength [mysql_query "SELECT * FROM $icel(tbl) WHERE unit = '$un'"]] == $icel(def)} {
    puthelp "notice $nc :table full ($icel(def)).  not added"
    putlog "icel: $nc on $ch did !a $tx (table full)"
    mysql_close
    return 0
  }

  if {[string length [join [lrange $pl 1 end]]] > $icel(chr)} {
    puthelp "notice $nc :key too long (+ $icel(chr) chars)"
    putlog "icel: $nc on $ch did !a $tx (definition too long)"
    mysql_close
    return 0
  }

  set ts [clock format [clock seconds] -format "%F %T"]
  set dn [mysql_escape [join [lrange $pl 1 end]]]

  mysql_query "INSERT INTO $icel(tbl) VALUES (null, '$ts', '$ch', '$hs', '$nc', '$un', '$dn')"

  set un [string length [lindex $pl 0]]
  set dn [string length [join [lrange $pl 1 end]]]
  set id [mysql_insert_id]

  mysql_close

  puthelp "notice $nc :key recorded (unit/defn: $un/$dn chars. id: $id)"
  putlog "icel: $nc on $ch did !a $tx (recorded)"
}
