# $Id: icel-get.tcl 2005-01-16 14:25:05 mferra $
# Copyright (C) 2004 - Marco Ferra <mferra@sdf.lonestar.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


proc pub:icel:get {nc hs hn ch tx} {
  global icel

  if {![string length $tx]} {
    puthelp "notice $nc :invalid syntax"
    return 0
  }

  set pl [split $tx]

  if {[icel:hdb]} {
    puthelp "notice $nc :can't open database"
    return 0
  }

  set un [mysql_escape [lindex $pl 0]]
  set bx [mysql_escape [lindex $pl 1]]
  set cx [mysql_escape [lindex $pl 2]]

  if {[string is integer -strict $bx]} {
    if {[string equal $cx "*"]} {
      set ax $nc
      set bx $bx
      set cx 1
    } elseif {[string equal $cx "."]} {
      set ax $ch
      set bx $bx
      set cx 0
    } elseif {[onchan $cx $ch]} {
      set ax $cx
      set bx $bx
      set cx 0
    } else {
      set ax $nc
      set bx $bx
      set cx 0
    }
  } elseif {[string equal $bx "*"]} {
    set ax $nc
    set bx 0
    set cx 1
  } elseif {[string equal $bx "."]} {
    set ax $ch
    set bx 0
    set cx 0
  } elseif {[onchan $bx $ch]} {
    set ax $bx
    set bx 0
    set cx 0
  } else {
    set ax $nc
    set bx 0
    set cx 0
  }

  if {$icel(cdb)} {
    if {!$bx} {
      set un [mysql_query "SELECT * FROM $icel(tbl) WHERE unit = '$un'"]
    } else {
      set un [mysql_query "SELECT * FROM $icel(tbl) WHERE unit = '$un' && id = '$bx'"]
    }
  } else {
    if {!$bx} {
      set un [mysql_query "SELECT * FROM $icel(tbl) WHERE unit = '$un' && chan = '$ch'"]
    } else {
      set un [mysql_query "SELECT * FROM $icel(tbl) WHERE unit = '$un' && id = '$bx' && chan = '$ch'"]
    }
  }

  mysql_close

  set bx [llength $un]

  if {$bx == 0} {
    puthelp "notice $nc :key not found.  deep searching ..."
    pub:icel:sch $nc $hs $hn $ch [lindex $pl 0]
    return 0
  }

  set dx 1

  foreach ds $un {
    if {$cx == 0} {
      puthelp "privmsg $ax :\[$dx/$bx Id: [lindex $ds 0]\] [join [lrange $ds 5 end]]"
    } else {
      set ex [lindex $ds 1]
      set fx [lindex $ds 4]
      set gx [lindex $ds 5]
      puthelp "privmsg $ax :\[$dx/$bx Id: [lindex $ds 0]\] $gx : $fx : $ex"
    }
    incr dx
  }

  putlog "icel: $nc on $ch did !! $tx ((found: $bx) done)"
}
