/*
  File autogenerated by gengetopt version 2.10
  generated with the following command:
  gengetopt --file-name=cmdline 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "getopt.h"

#include "cmdline.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  This program plots the attractor (fractal) of an IFS.\n"
  "  \n"
  "  You can provide as many affine transformations you like.  Each affine\n"
  "  transformation is represented as one line with seven quantities, read\n"
  "  from the standart input. These quantities, namely a b c d e f p,\n"
  "  represent an affine transformation of the form\n"
  "  \n"
  "      w(x,y) = (ax + by + e, cx + dy + f).\n"
  "  \n"
  "  The last number, denoted by p, is a probability assossiated to the\n"
  "  affine transformation. You can think that this probability will\n"
  "  control the density of points on w(A), where w is the affine\n"
  "  transformation and A is the attractor.\n"
  "  \n"
  "  Remember that the propabilities must sum up one.\n"
  "  \n"
  "  For further informations on IFS fractals, we report interested people\n"
  "  to the classical IFS book:\n"
  "    Fractals Everywhere\n"
  "    Michael Barnsley\n"
  "    Addison-Wesley, 2nd ed., 2000.\n"
  "  \n"
  "  Several output drivers are supported: X, Xdrawable, pnm,\n"
  "  gif, ai, png, ps, fig, pcl, hpgl, tek, or meta.\n"
  "  \n"
  "  This program is distributed under the terms of the\n"
  "  GNU Public License.\n"
  "  \n"
  "  Copyright (c) 2005, 2004, 2003 Ricardo Biloti <biloti@ime.unicamp.br>\n"
  "  Department of Applied Mathematics\n"
  "  State University of Campinas, Brazil.\n"
  "  \n"
  "\n"
  "Usage: %s [OPTIONS]...\n", CMDLINE_PARSER_PACKAGE);
  printf("   -h         --help           Print help and exit\n");
  printf("   -V         --version        Print version and exit\n");
  printf("   -c         --color          Color each transformation (default=off)\n");
  printf("   -DSTRING   --driver=STRING  Output driver (see above) (default='X')\n");
  printf("   -NLONG     --maxint=LONG    Iteration number (default='100000')\n");
  printf("   -nLONG     --minint=LONG    Initial iterations to discard (default='200')\n");
  printf("              --nmax=INT       Maximun number of transformations (default='50')\n");
  printf("              --xi=DOUBLE      x min coordinate\n");
  printf("              --xf=DOUBLE      x max coordinate\n");
  printf("              --yi=DOUBLE      y min coordinate\n");
  printf("              --yf=DOUBLE      y max coordinate\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->color_given = 0 ;
  args_info->driver_given = 0 ;
  args_info->maxint_given = 0 ;
  args_info->minint_given = 0 ;
  args_info->nmax_given = 0 ;
  args_info->xi_given = 0 ;
  args_info->xf_given = 0 ;
  args_info->yi_given = 0 ;
  args_info->yf_given = 0 ;
#define clear_args() { \
  args_info->color_flag = 0;\
  args_info->driver_arg = gengetopt_strdup("X") ;\
  args_info->maxint_arg = 100000 ;\
  args_info->minint_arg = 200 ;\
  args_info->nmax_arg = 50 ;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "color",	0, NULL, 'c' },
        { "driver",	1, NULL, 'D' },
        { "maxint",	1, NULL, 'N' },
        { "minint",	1, NULL, 'n' },
        { "nmax",	1, NULL, 0 },
        { "xi",	1, NULL, 0 },
        { "xf",	1, NULL, 0 },
        { "yi",	1, NULL, 0 },
        { "yf",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVcD:N:n:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'c':	/* Color each transformation.  */
          if (args_info->color_given)
            {
              fprintf (stderr, "%s: `--color' (`-c') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->color_given = 1;
          args_info->color_flag = !(args_info->color_flag);
          break;

        case 'D':	/* Output driver (see above).  */
          if (args_info->driver_given)
            {
              fprintf (stderr, "%s: `--driver' (`-D') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->driver_given = 1;
          args_info->driver_arg = gengetopt_strdup (optarg);
          break;

        case 'N':	/* Iteration number.  */
          if (args_info->maxint_given)
            {
              fprintf (stderr, "%s: `--maxint' (`-N') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->maxint_given = 1;
          args_info->maxint_arg = strtol (optarg,&stop_char,0);
          break;

        case 'n':	/* Initial iterations to discard.  */
          if (args_info->minint_given)
            {
              fprintf (stderr, "%s: `--minint' (`-n') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->minint_given = 1;
          args_info->minint_arg = strtol (optarg,&stop_char,0);
          break;


        case 0:	/* Long option with no short option */
          /* Maximun number of transformations.  */
          if (strcmp (long_options[option_index].name, "nmax") == 0)
          {
            if (args_info->nmax_given)
              {
                fprintf (stderr, "%s: `--nmax' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->nmax_given = 1;
            args_info->nmax_arg = strtol (optarg,&stop_char,0);
            break;
          }
          
          /* x min coordinate.  */
          else if (strcmp (long_options[option_index].name, "xi") == 0)
          {
            if (args_info->xi_given)
              {
                fprintf (stderr, "%s: `--xi' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->xi_given = 1;
            args_info->xi_arg = strtod (optarg, NULL);
            break;
          }
          
          /* x max coordinate.  */
          else if (strcmp (long_options[option_index].name, "xf") == 0)
          {
            if (args_info->xf_given)
              {
                fprintf (stderr, "%s: `--xf' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->xf_given = 1;
            args_info->xf_arg = strtod (optarg, NULL);
            break;
          }
          
          /* y min coordinate.  */
          else if (strcmp (long_options[option_index].name, "yi") == 0)
          {
            if (args_info->yi_given)
              {
                fprintf (stderr, "%s: `--yi' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->yi_given = 1;
            args_info->yi_arg = strtod (optarg, NULL);
            break;
          }
          
          /* y max coordinate.  */
          else if (strcmp (long_options[option_index].name, "yf") == 0)
          {
            if (args_info->yf_given)
              {
                fprintf (stderr, "%s: `--yf' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->yf_given = 1;
            args_info->yf_arg = strtod (optarg, NULL);
            break;
          }
          

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    exit (EXIT_FAILURE);

  return 0;
}
