/***************************************************************************/
/*                                                                         */
/* ifsplot.h - header file for ifsplot                                     */
/* Copyright (C) 2003 Ricardo Biloti <biloti@mat.ufpr.br>                  */
/*                    http://www.mat.ufpr.br/~biloti                       */ 
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2, or (at your option)     */
/* any later version.                                                      */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the                           */
/* Free Software Foundation, Inc., 59 Temple Place - Suite 330,            */
/* Boston, MA 02111-1307, USA.                                             */
/*                                                                         */
/***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <plot.h>
#include "cmdline.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef _SQR
#define _SQR 1
#define sqr(x)           ( ((x)*(x)) )
#endif

#ifndef _MAX
#define _MAX 1
#define max(x,y)         ( ((x) < (y)) ? (y) : (x) )
#endif

#ifndef _MIN
#define _MIN 1
#define min(x,y)         ( ((x) > (y)) ? (y) : (x) )
#endif

int ifspoint(float **ifs, float *x, float *y);
void center(int N, float **ifs, float *x, float *y);
float radius(int N, float **ifs, float x, float y);
