<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


//set up user class and destroy any sessions
require_once($c_node['dir']['class_path'] . 'User.class.php');
require_once($c_node['dir']['class_path'] . 'UserAdmin.class.php');
$user = new UserAdmin($db, $date);


//form actions
if (isset($_POST['newpassword'])) {
	// Checks the email and the password
	$catpcha = strtoupper($_POST['captchastring']);
	if (empty($catpcha) || empty($_SESSION['CAPTCHAString']) || $_SESSION['CAPTCHAString'] != $catpcha) {
		$GLOBALS['igloo_error_log'][] = array(36, null, null);
	}
	
	if (empty($GLOBALS['igloo_error_log'])) {
		$dob = $_POST['year']."-".$_POST['month']."-".$_POST['day'];

		$query = "
			SELECT u.user_id, u.user_firstname, u.user_email
			FROM " . $db->prefix . "_user u
			where
			u.user_email='" . $_POST['email'] . "' and
			u.user_dob='" . $dob . "'"
		;
		
		$result = $db->Execute($query);
	
		if (isset($result->fields['user_id'])) {
			$temp = $result->fields;
	
			//update the password and send email
			$password = $user->createPassword();
			$user->savePassword($password, $temp['user_email']);
	
			//get file to send
			$body_file = $languageTextPath . "send_new_password.txt.php";
	
			$handle = fopen($body_file, "rb");
			$body_file_txt = "";
			do {
			   $data = fread($handle, 8192);
			   if (strlen($data) == 0) {
			       break;
			   }
			   $body_file_txt .= $data;
			} while (true);
			fclose($handle);
	
	
			$body_file_txt = str_replace("\\\"", "\"", $body_file_txt);
			$body_file_txt = str_replace("FIRSTNAME", $temp['user_firstname'], $body_file_txt);
			$body_file_txt = str_replace("PASSWORD", $password, $body_file_txt);
			
			//create URL
			$url = "http://" . $_SERVER['HTTP_HOST'];
			$url .= dirname ($_SERVER['PHP_SELF']);
			//sometimes the server adds / as the last characture - we need to check.
			if (substr($url, -1, 1) != "/") {
			    $url .= "/";
			}
			
			$body_file_txt = str_replace("URL", $url, $body_file_txt);
	
	
			//setup mail
			require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
			$mail = new PHPMailer();
			$mail->Host = 		$c_node['mail']['host'];
			$mail->Port = 		$c_node['mail']['port'];
			$mail->Mailer = 	$c_node['mail']['mailer'];
			
			if (isset($c_node['mail']['smtp']['username'])) {
				$mail->SMTPAuth = true;
				$mail->Username = $c_node['mail']['smtp']['username'];
				$mail->Password = $c_node['mail']['smtp']['password'];
			}
			
			$mail->From = 		$c_node['mail']['no_reply_address'];
			$mail->FromName = 	$c_node['mail']['from_name'];
			$mail->WordWrap = 	$c_node['mail']['wordwrap'];
			$mail->Subject = 	$lang['txt_email_subject_new_pass'];
			$mail->AddAddress($temp['user_email'], $temp['user_firstname']);
			$mail->Body = $body_file_txt;
	
	
			if(!$mail->Send()) {
				$GLOBALS['igloo_error_log'][] = array(23, 1, $mail->ErrorInfo);
			}
		}
		else {
			$GLOBALS['igloo_error_log'][] = array(22, null, null);
		}
	
		$display = "sent_pass";
		
		if (!empty($GLOBALS['igloo_error_log'])) {
			$display = "lost_pass";
		}
	}
}

//TEMPLATE
if (isset($c_node['node']['language']['pack'])) {
	$body->set('language_available', $c_node['node']['language']['pack']);
}

if (isset($display)) {
	$body->set('display', $display);
}

$body->set('datedropdown', $date->dateDropdown());

include "inc/footer.inc.php";

?>
