<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<div class="col_main">
	<?php
	if (isset($blog)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $this->date->formatDate($blog['blog_create_datetime'], 1);?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<h2><?php echo $blog['blog_title'];?></h2>
					
				<p>
				<?php echo $blog['blog_body_display'];?><br />
				</p>
				
				<div class="metadata">
					<?php
					if (isset($author)) {
					?>
						<p>
							<b><?php echo $lang['txt_author'];?></b> -&#62; 
							<?php echo $lang['txt_profile_nic'];?>: 
							<a href="sn_profile.php?user_id=<?php echo $author['user_id'];?>"><?php echo $author['profile_nic'];?></a>, 
							<?php echo $lang['txt_profile_session_status'];?>: 
							<?php
							if ($author['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
							}
							else {
									echo $lang['arr_user_online_status'][$author['online_status']];
							}
							?>, 
							<?php echo $lang['txt_hometown'];?>: 
							<?php echo $author['profile_hometown'];?>, 
							<?php echo $lang['txt_joined'];?>: 
							<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
							<br />
						</p>
					<?php }?>
					
					<p>
						<b><?php echo $lang['hdr_blog_entry'];?></b> -&#62; 
						<?php
						if (!empty($blog['bookmark'])) {
							echo $lang['txt_bookmarks'] . ": ";
							
							if (!empty($blog['bookmark']['watch'])) {
								echo $lang['txt_marked'];
							}
			
							if (!empty($blog['bookmark']['recommend'])) {
								echo $lang['txt_tipped'];
							}
							echo ", ";
						}
						?>
						<?php
						if ($blog['blog_create_datetime'] != $blog['blog_edit_datetime'] && !empty($blog['blog_edit_datetime'])) {
							echo $lang['txt_last_edited'] . ": ";
							echo $this->date->formatDate($blog['blog_edit_datetime'], 1) . ", ";
						}
						?>
						<?php echo $lang['txt_published_to'];?>: 
						<?php
						if (isset($blog['rsp'])) {
							foreach($blog['rsp'] as $key => $i):
								
								echo trim($lang['rsp']['rsp_level'][$i['level_id']] . " " . $i['degree_id']);
								echo " (" .$lang['rsp']['status'][$i['status_id']] . ")";
								if ($key+1 < count($blog['rsp'])) {
									echo ", ";
								}
								
							endforeach;
						}
					?>
					<br />
					</p>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				//comments
				if (isset($me['user_id']) && $blog['user_id'] == $me['user_id']) {
					$unlocked = 1;
				}
				
				if (!empty($blog['blog_allow_comments'])) {
					$unlocked = 1;
				}
					
				$hidden_form = array(
					"blog_id" => $blog['blog_id']
				);
				
				if (isset($_REQUEST['user_id'])) {
					$hidden_form['user_id'] = $_REQUEST['user_id'];
				}
				
				include $templatePath . "comment.inc.tpl.php";
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($blogs)) { //list view
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_blogs'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<?
					foreach($blogs as $key => $i):
					?>
					<tr>
						<td width="1" rowspan="2">
							<img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /><br />
						</td>
						<td valign="top" nowrap="nowrap">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime'], 1);?></a><br />
							
						</td>
						<td valign="top">
							<?php echo $i['blog_title'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<tr>
						<td colspan="3">
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php
	}
	else  { //error - no blogs
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_blogs'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['err_no_blog'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<form action="blg_view.php" method="post" name="frm_view" id="id_frm_view">
				<input type="hidden" name="blog_id" value="<?php if(isset($blog['blog_id'])) { echo $blog['blog_id'];}?>" />
				<input type="hidden" name="user_id" value="<?php if(isset($blog['user_id'])) { echo $blog['user_id'];}?>" />
				
				<p>
					<select name="options" class="options_select">
					<option value="list_node" selected="selected"><?php echo $lang['txt_option_group'];?></option>
					
					<?php
					if (isset($me['user_id'])) {
					?>
						<?php
						$selected = "";
						if (isset($frmdata) && $frmdata['options'] == "list_relation") {
						$selected = "selected=\"selected\"";
						}
						?>
						<option value="list_relation" <?php echo $selected;?>><?php echo $lang['txt_option_network'];?></option>
						
						<?php
						$selected = "";
						if (isset($frmdata) && $frmdata['options'] == "list_my") {
						$selected = "selected=\"selected\"";
						}
						?>
						<option value="list_my" <?php echo $selected;?>><?php echo $lang['txt_option_items'];?></option>
						
						<?php
						$selected = "";
						if (isset($frmdata) && $frmdata['options'] == "list_marked") {
						$selected = "selected=\"selected\"";
						}
						?>
						<option value="list_marked" <?php echo $selected;?>><?php echo $lang['txt_option_marked'];?></option>
						
						<?php
						$selected = "";
						if (isset($frmdata) && $frmdata['options'] == "list_relation_tips") {
						$selected = "selected=\"selected\"";
						}
						?>
						<option value="list_relation_tips" <?php echo $selected;?>><?php echo $lang['txt_option_tipped'];?></option>
					<?php }?>
					
					<?php
					if (isset($blog)) {
					?>
					<option value="list_user"><?php echo $lang['txt_option_list'];?></option>
					<?php }?>
					<option> </option>
					<?php
					if (isset($blog)) {
					?>
						<?php
						if (isset($me['user_id'])) {
						?>
							<?php
							if (empty($blog['bookmark']['watch'])) {
							?>
							<option value="item_mark"><?php echo $lang['txt_option_mark'];?></option>
							<?php }?>
						
							<?php
							if (empty($blog['bookmark']['recommend'])) {
							?>
							<option value="item_tip"><?php echo $lang['txt_option_tip'];?></option>
							<?php }?>
						<?php }?>
					<?php }?>
					
					<?php
					if (isset($blog) && $this->user_acs->checkPermission($resource_ids['blog'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
					?>
					<option value="item_edit"><?php echo $lang['txt_option_edit'];?></option>
					<?php }?>
					
					<?php
					if ($this->user_acs->checkPermission($resource_ids['blog'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
					?>
					<option value="item_add"><?php echo $lang['txt_option_add'];?></option>
					<?php }?>
					</select>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="option_action" class="go" /><br />
				</p>
				
				<p>
				<?php
				if (isset($blog)) {
				?>
					<p>
					<b><?php echo $lang['hdr_tag'];?></b><br />
					</p>
					
					<p>
					<?php
					$tags = "";
					if (isset($item_tags)) {
						foreach ($item_tags as $key => $i):
							$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							
							if ($i['user_id'] == $me['user_id']) {
								$tags .= "*";
							}
							
							if (count($item_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
						echo $tags;
					}
					?>
				</p>
					
				<?php
				if ($this->user_acs->checkPermission($resource_ids['blog'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
				$tags = "";
				if (isset($my_tags)) {
					foreach ($my_tags as $key => $i):
						$tags .= $i['tag_body'];
						if (count($my_tags) > $key+1) {
							$tags .= ", ";
						}
					endforeach;
				}
				?>
				
				<p>
					<input width="30" name="tags" value="<?php echo $tags;?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="update_tag" class="go" /><br />
				</p>
				<?php }?>
				<?php }?>
					
				<p>
					<h3><?php echo $lang['hdr_search'];?></h3>
				</p>
				
				<p>
					<input type="text" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php 
	if (isset($sidebar_blogs)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_blog'];?><br />
		</div>
	
		<div class="box_mid">
			<div class="content">
				<?
				foreach($sidebar_blogs as $key => $i):
				if (!isset($blog) || isset($blog) && $blog['blog_id'] != $i['blog_id']) {
				?>
				<p>
					<?php echo $i['blog_title'];?><br />
					<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime']);?></a> 
					<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
					<br />
				</p>
				<?php
				}
				endforeach;
				?>
				<p>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" name="list_all" value="list_all" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	</form>
</div>
