<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<?php
if (isset($display) && $display == "deny") {
?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_profile'];?><br />
		</div>
								
		<div class="box_mid">
				<div class="content">
					<?php echo $lang['txt_deny_view'];?><br />
				</div>
			</div>
		</div>
			
		<div class="box_bottom">
			<span class="box_bottom_right"></span>
			<span class="box_bottom_left"></span>
		</div>
	</div>
<?php
}
else {
?>
<form action="sn_profile.php" method="post">
<input type="hidden" name="user_id" value="<?php echo $profile['user_id'];?>" />

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_summary'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($display) && $display == "block") {
				?>

				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<tr>
						<td colspan="2">
							<b><?php echo $lang['hdr_block'];?></b><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_block_description_text'];?><br />
						</td>
						<td>
							<textarea rows="3" cols="25" name="block_description" class="formInput"></textarea><br />
						</td>
					</tr>
					<tr>
						<td align="right" colspan="2">
							<input type="submit" name="set_block" value="<?php echo $lang['sub_block'];?>" class="button_urgent" /><br />
							<br />
						</td>
					</tr>
				</table>
				
				<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" /><br />
				<?php }?>
				
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<tr>
						<td valign="top">
							<?php echo $profile['profile_summary'];?><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
			
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_relationship'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php
					if (isset($relationship_paths)) {
					foreach($relationship_paths as $key => $r):
					?>
						<?php
						foreach($r['relation'] as $key1 => $i):
							if ($i == $me['user_id']) {
								echo $lang['txt_me'];
							}
							else {
							
								foreach($relationship_profiles as $keyrp => $rp):
									if ($i == $rp['user_id']) {
										if (count($r['relation']) > $key1+1) {
											echo "<a href=\"sn_profile.php?user_id=" . $rp['user_id'] . "\">" . $rp['profile_nic'] . "</a>";
										}
										else {
											echo $rp['profile_nic'];
										}
										
										break;
									}
								endforeach;
							}
							?>
						<?php
						if (count($r['relation']) > $key1+1) {
							echo "-&#62;";
						}
						?>
						<?php 
						endforeach;
						?>
					<br />
					<?php
					endforeach;
					}
					?>
				</p>
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<tr>
						<td>
							<table width="100%" cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td width="50%" valign="top">
										<?php
										if (isset($profile['relation_to'])) {
										?>
											<b><?php echo $lang['txt_is_acquaintance'];?></b><br />
											<?php echo $lang['txt_is_acquaintance_intro'];?><br />
											<br />
											<table cellpadding="4" cellspacing="0" border="0">
												<tr>
													<td>
														<?php echo $lang['sub_reveal_ts'];?><br />
													</td>
													<td>
														<input id="id_relation_show_true_self" type="checkbox" name="relation_show_true_self" class="checkbox" value="1" <?php if (!empty($profile['relation_to']['relation_show_true_self'])) { echo "checked=\"checked\"";}?> /><br />
													</td>
												</tr>
												<tr>
													<td>
														<?php echo $lang['sub_reveal_nw'];?><br />
													</td>
													<td>
														<input id="id_relation_show_network" type="checkbox" name="relation_show_network" class="checkbox" value="1" <?php if (!empty($profile['relation_to']['relation_show_network'])) { echo "checked=\"checked\"";}?> /><br />
													</td>
												</tr>
												<tr>
													<td align="right" colspan="2">
														<input type="submit" name="update_relation" class="button_urgent" value="<?php echo $lang['sub_update'];?>" /><br />
													</td>
												</tr>
											</table>
											
										<?php
										}
										elseif ($this->user_acs->checkPermission($resource_ids['network'], $privilege_ids['allow_network_int'])) { //resourece_id, Priv_id
										?>
											<b><?php echo $lang['txt_nw_invite'];?></b><br />
											<p>
											<?php
											if (!empty($profile['relation_to_pending'])) {
												echo $lang['txt_nw_invite_pending'];
											}
											else {
											?>
											<?php echo $lang['txt_nw_invite_intro'];?><br />
											</p>
											<table cellpadding="0" cellspacing="0" border="0">
												<tr>
													<td>
														<textarea name="invite_message" cols="30" rows="3"></textarea><br />
														<br />
													</td>
												</tr>
												<tr>
													<td align="right">
														<input type="submit" name="invite_relation" class="button_urgent" value="<?php echo $lang['sub_invite'];?>" /><br />
													</td>
												</tr>
											</table>
											<p>
											
										<?php }?>
											</p>
										<?php }?>
									</td>
									<td width="20">
										<img src="<?php echo $templatePath;?>img/pixel.png" width="20" height="1" alt="" /><br />
									</td>
									<td width="50%" valign="top">
										<b><?php echo $lang['txt_blocking'];?></b><br />
										<?php echo $lang['txt_blocking_intro'];?><br />
										<p>
										<?php
										if (isset($display) && $display == "blocked") {
										?>
										<a href="sn_profile.php?user_id=<?php echo $profile['user_id'];?>&amp;unblock=1"><?php echo $lang['href_unblock'];?></a><br />
										<?php
										}
										elseif (isset($profile['user_id']) && $profile['user_id'] != $me['user_id']) {
										?>
										<a href="sn_profile.php?user_id=<?php echo $profile['user_id'];?>&amp;block=1"><?php echo $lang['href_block'];?></a><br />
										<?php }?>
										</p>
										
										<?php
										if (isset($profile['relation_to'])) {
										?>
										<b><?php echo $lang['txt_remove_relation'];?></b><br />
										<?php echo $lang['txt_remove_relation_intro'];?><br />
										<p align="right">
										<input type="submit" name="delete_relation" class="button_urgent" value="<?php echo $lang['sub_remove'];?>" /><br />
										</p>
										<?php }?>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td>
							<hr />
						</td>
					</tr>
					<tr>
						<td>
							<b><?php echo $lang['txt_acquaintances'];?></b><br />
							<?php
							
							if (isset($relationship_relations)) {
								foreach($relationship_relations as $key => $i):
									if (isset($relationship_relations_profiles)) {
										foreach($relationship_relations_profiles as $keyrp => $rp):
											if ($i['user_id_relation'] == $rp['user_id']) {
												echo "<a href=\"sn_profile.php?user_id=" . $rp['user_id'] . "\">" . $rp['profile_nic'] . "</a>";
												unset($relationship_relations_profiles[$keyrp]);
												if (!empty($relationship_relations_profiles)) {
													echo ", ";
												}
												break;
											}
										endforeach;
									}
								endforeach;
							}
							else {
								echo $lang['err_no_relations'];
							}
							?>
							<br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
			
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_contact'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					if (!empty($lang['txt_profile_text1'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text1'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text1'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text2'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text2'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text2'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text3'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text3'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text3'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text4'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text4'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text4'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text5'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text5'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text5'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text6'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text6'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text6'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text7'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text7'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text7'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text8'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text8'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text8'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text9'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text9'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text9'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text10'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text10'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text10'];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
			
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_publishing'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<tr>
						<td valign="top" width="50%">
							<table width="100%" cellpadding="4" cellspacing="0" border="0">
								<tr>
									<td colspan="2">
										<b><?php echo $lang['hdr_blogs'];?></b><br />
									</td>
								</tr>
								<?php
								if (isset($blogs)) {
								foreach($blogs as $key => $i):
								?>
								<tr>
									<td valign="top" width="1%">
										<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><img align="right" src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
									</td>
									<td valign="top">
										<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime']);?></a><br />
										<b><?php echo $i['blog_title'];?></b><br />
										<span class="txt_footer"><?php echo $i['blog_synopsis'];?></span><br />
									</td>
								</tr>
								<?php
								endforeach;
								} else {
								?>
								<tr>
									<td colspan="2">
										<?php echo $lang['err_no_blogs'];?><br />
									</td>
								</tr>
								<?php }?>
							</table>
							
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
							
							<table width="100%" cellpadding="4" cellspacing="0" border="0">
								
								<tr>
									<td colspan="2">
										<b><?php echo $lang['hdr_library_items'];?></b><br />
									</td>
								</tr>
								<?php
								if (isset($library)) {
								foreach($library as $key => $i):
								?>
								<tr>
									<td valign="top" width="1%">
										<a href="lib_view.php?page=<?php echo $i['library_page_name'];?>"><img align="right" src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
									</td>
									<td valign="top">
										<a href="lib_view.php?page=<?php echo $i['library_page_name'];?>"><?php echo $i['library_title'];?></a><br />
										<b><?php echo $i['library_title'];?></b><br />
										<span class="txt_footer"><?php echo dots('180', $i['library_synopsis']);?></span><br />
									</td>
								</tr>
							<?php
								endforeach;
								} else {
								?>
								<tr>
									<td colspan="2">
										<?php echo $lang['err_no_library'];?><br />
									</td>
								</tr>
							<?php }?>
							</table>
							
						</td>
						<td width="20">
							<img src="<?php echo $templatePath;?>img/pixel.png" width="20" height="1" alt="" border="0" /><br />
						</td>
						<td valign="top" width="50%">
							<table width="100%" cellpadding="4" cellspacing="0" border="0">
								
								<tr>
									<td colspan="2">
										<b><?php echo $lang['hdr_subjects'];?></b><br />
									</td>
								</tr>
								<?php
								if (isset($subjects)) {
								foreach($subjects as $key => $i):
								?>
								<tr valign="top">
									<td valign="top" width="1%">
										<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><img align="right" src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
									</td>
									<td valign="top">
										<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><?php echo $this->date->formatDate($i['subject_create_datetime']);?></a><br />
										<b><?php echo $i['subject_title'];?></b><br />
										<span class="txt_footer"><?php echo $i['subject_synopsis'];?></span><br />
									</td>
								</tr>
								<?php
								endforeach;
								} else {
								?>
								<tr>
									<td colspan="2">
										<?php echo $lang['err_no_forum'];?><br />
									</td>
								</tr>
								<?php }?>
							</table>
							
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
							
							<table width="100%" cellpadding="4" cellspacing="0" border="0">
								
								<tr>
									<td colspan="2">
										<b><?php echo $lang['hdr_comments'];?></b><br />
									</td>
								</tr>
								<?php
								if (isset($comments)) {
								foreach($comments as $key => $i):
								?>
								<tr>
									<td width="3" valign="top">
										<img src="<?php echo $templatePath;?>img/dot.png" width="3" height="9" alt="" /><br />
									</td>
									<td valign="top">
										<b>
										<?php
										if ($rsp_item_type_ids['blog'] == $i['rsp_item_type_id']) {
										?>
										<a href="blg_view.php?blog_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
										<?php
										}
										elseif ($rsp_item_type_ids['library'] == $i['rsp_item_type_id']) {
										?>
										<a href="lib_view.php?library_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
										<?php
										}
										elseif ($rsp_item_type_ids['forum'] == $i['rsp_item_type_id']) {
										?>
										<a href="frm_view.php?subject_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
										<?php
										}
										elseif ($rsp_item_type_ids['poll'] == $i['rsp_item_type_id']) {
										?>
										<a href="pol_view.php?poll_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
										<? }?>
										</b><br />
										
										<p>
										<?php echo dots(160, $i['comment_body']);?><br />
										</p>
									</td>
								</tr>
								<?php
								endforeach;
								} else {
								?>
								<tr>
									<td colspan="2">
										<?php echo $lang['err_no_comments'];?><br />
									</td>
								</tr>
							<?php }?>
							</table>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<?php
	if (isset($profile['profile_id'])) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $profile['profile_nic'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<img src="get_file.php?file=<?php echo $profile['image']['file'];?>" border="0" alt="<?php echo $profile['image']['file_title'];?>" /><br />
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_profile_session_status'];?><br />
						</td>
						<td>
							<?php
							if ($profile['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$profile['online_status']] . "<br />";
							}
							?>
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_hometown'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_hometown'];?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_joined'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($profile['profile_create_datetime']);?><br />
						</td>
					</tr>
				</table>
				
				<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" /><br />
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td valign="top" align="center" colspan="2">
							<?php
							if (isset($profile['relation_to'])) {
								echo "<img src='" . $templatePath . "img/sn_connected_to_them.png' width='16' height='16' title='" .  $lang['txt_help_icon_conn'] . "' alt='" .  $lang['txt_help_icon_conn'] . "' />&nbsp;";
								
								if (!empty($profile['relation_to']['relation_show_network'])) {
									echo "<img src='" . $templatePath . "img/sn_they_see_my_nw.png' width='16' height='16' title='" . $lang['txt_help_icon_net'] . "' alt='" . $lang['txt_help_icon_net'] . "' />&nbsp;";
								}
								
								if (!empty($profile['relation_to']['relation_show_true_self'])) {
									echo "<img src='" . $templatePath . "img/sn_true_self_revealed_to_them.png' width='16' height='16' title='" . $lang['txt_help_icon_ts'] . "' alt='" . $lang['txt_help_icon_ts'] . "' />&nbsp;";
								}
							}
							?><br />
						</td>
					</tr>
					<?php
					if (!empty($profile['profile_allow_msg'])) {
					?>
					<tr>
						<td>
							<a href="msg_edit.php?to_user_id=<?php echo $profile['user_id'];?>"><?php echo $lang['menu_send_message'];?></a><br />
						</td>
					</tr>
					<?php }?>
				</table>
				<br />
				
				<?php
				if (isset($statistics)) {
				?>
				<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" border="0" /><br />
						
				<table border="0" width="100%" cellspacing="2" cellpadding="2" class="picture_light">
					<tr>
						<td class="bg2" colspan="2">
							<b><?php echo $lang['menu_statistics'];?></b><br />
						</td>
					</tr>
					<?php
					foreach($statistics as $key => $i):
					if (isset($lang['arr_user_statistic_type_id'][$i['statistic_type_id']])) {
					?>
					<tr>
						<td class="bg3">
							<?php echo $lang['arr_user_statistic_type_id'][$i['statistic_type_id']];?><br />
						</td>
						<td align="right" class="bg4">
							<?php echo $i['total'];?><br />
						</td>
					</tr>
					<?php
					}
					endforeach;
					?>
				</table>
				<?php }?>	
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
			
	<?php
	if ($this->user_acs->checkPermission($resource_ids['network'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_tag'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
				<?php
				$tags = "";
				if (isset($my_tags)) {
					foreach ($my_tags as $key => $i):
						$tags .= "<a href='sn_list.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
						
						if (count($my_tags) > $key+1) {
							$tags .= ", ";
						}
					endforeach;
					echo $tags;
				}
				?>
				</p>
				
				<p>
					<?php
					$tags = "";
					if (isset($my_tags)) {
						foreach ($my_tags as $key => $i):
							$tags .= $i['tag_body'];
							if (count($my_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
					}
					?>
				</p>
				
				<p>
					<input width="30" name="tags" value="<?php echo $tags;?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" name="update_tag" value="1" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>
</form>
<?php }?>
