<?php

// -----------------------------------------------------------------------
// This file is part of igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// Igloofile - render a file with or without thumb


class Text_Wiki_Render_Xhtml_File extends Text_Wiki_Render {
	
    var $conf = array(
        'css'  => null,
        'css_link' => null
    );
    
    
    /**
    * 
    * Renders a token into text matching the requested format.
    * 
    * @access public
    * 
    * @param array $options The "options" portion of the token (second
    * element).
    * 
    * @return string The text rendered from the token options.
    * 
    */
    
    function token($options)
    {
        
		global $c_node, $template_path, $group_id;
		
		$attributes = "";
		$start = "";
		$end = "";
		
		// note the image source
        $src = $options['src'];
        
		//if we have a thumb we create the thumb html
        if (isset($options['attr']['thumb'])) {
			$file_suffix = substr($src, -3);
			$thumb_html = "<img src='" . $template_path . "img/file_" . $file_suffix . ".png' alt='' border='0' />&nbsp;";
			unset($options['attr']['thumb']);					
        }
		
		//if we align we place it in a div tag
		if (isset($options['attr']['align'])) {
			$start = '<div style="float:right"';
			$end = '</div>';
			unset($options['attr']['align']);					
        }
		
		// we create the html for the file and link
		$file_html = '<a href="get_file.php?file=' . htmlspecialchars($src) . '"';
        
		//do we have a css
		if (isset($options['attr']['class'])) {
			if (!empty($start)) {
				$start .= 'class="' . $options['attr']['class'] . '"';
				$file_html .= " />" . htmlspecialchars($src) . "</a>";
			}
			else {
				$start .= "";
				$file_html .= 'class="' . $options['attr']['class'] . '"';
			}
			unset($options['attr']['class']);					
        }
		
		$attributes = "";
		// create the attributes
        foreach ($options['attr'] as $key => $val) {
            $key = htmlspecialchars($key);
            $val = htmlspecialchars($val);
            $attributes = " $key=\"$val\"";
        }
		
        
		$file_html .= $attributes . '>' . htmlspecialchars($src) . '</a>';
        
		
		//to align the icon/link we draw a table around it
		if (isset($thumb_html)) {
			$output = '<table cellspacing="0" border="0" cellpadding="2"><tr><td valign="top">' . $thumb_html . '</td><td valign="top">' . $file_html . '</td></tr></table>';
		}
		else {
			$output = $file_html;
		}
		
        $output = $start . $output . $end;
        
        return $output;
    }
}
?>