<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


include "inc/header.inc.php";


//setup useradmin (extends user)
require_once('class/User.class.php');
require_once('class/UserAdmin.class.php');
$user = new UserAdmin($db, $date);


//form processing
if (isset($_POST['setup'])) {
	
	$user->user_id = $frmdata['user_id'];
	$output_user = $user->getUser();
	
	//check the access code
	$query = "
		SELECT user_id
		FROM " . $db->prefix . "_user
		WHERE
		user_id=" . $frmdata['user_id'] . " AND
		user_password=" . $db->qstr(MD5($frmdata['access_code']), get_magic_quotes_gpc())
	;
	
	$result = $db->Execute($query);
	
	if(!isset($result->fields['user_id']) || $result->fields['user_id'] < 0) {
		$GLOBALS['igloo_error_log'][] = array(27, null, null);//access code wrong
	}
	
	if(isset($frmdata['user_password1']) && isset($frmdata['user_password2']) && $frmdata['user_password1'] != $frmdata['user_password2']) {
		$GLOBALS['igloo_error_log'][] = array(15, null, null);
	}

	if(isset($frmdata['user_password1']) && strlen($frmdata['user_password1']) < 5) {
		$GLOBALS['igloo_error_log'][] = array(16, null, null);
	}
	
	if (!empty($frmdata['to'])) {
		//check for emails
		$emails = trim($frmdata['to']);
		$emails = preg_split("/[\s,]+/", $emails);

		//check each email
		foreach($emails as $key => $i):

			if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $i)) {
				$GLOBALS['igloo_error_log'][] = array(3, null, $i); //email invalid
			}
		endforeach;
	}
	
	if (empty($GLOBALS['igloo_error_log'])) {
		//setup social network
		require_once('class/SocialNetwork.class.php');
		$sn = new SocialNetwork($frmdata['user_id'], $db, $c_node['sn']['max_degree']);
		$sn->relation_type_ids = $c_node['user']['relation_type'];
		$sn->status_ids = $c_node['user']['status'];
		$user->sn = $sn;
		
		//setup statistics
		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db, 1, null);
		$user->statistic = $statistic;
		$user->total_login_stat_id = $c_node['statistic']['user']['total_logins'];
		
		//setup instant messaging
		require_once('class/IM.class.php');
		$im = new IM($output_user['user_id'], $db, $c_node['messaging']['message_box_max_size']);
		$im->setStatus($c_node['messaging']['message_status_unread'], $c_node['messaging']['message_status_read']);
		$im->setBoxes($c_node['messaging']['message_in_box'], $c_node['messaging']['message_save_box'], $c_node['messaging']['message_out_box']);
		$user->im = $im;
		
		$user->body_welcome_txt = readTxtFile($languageTextPath . "im_welcome.txt.php");
		$user->body_invitee_txt = readTxtFile($languageTextPath . "im_invitee_joined.txt.php");
		$user->user_firstname = $output_user['user_firstname'];
		$user->user_email = $output_user['user_email'];
		$user->language_id = $output_user['language_id'];
		$user->subject_im_welcome = $lang['subject_im_welcome'];
		$user->relation_type = $c_node['user']['relation_type'];
		$user->subject_im_joined = $lang['subject_im_joined'];
		$user->status_id = $c_node['user']['status']['active'];
		$user->txt_invite = $lang['txt_invite'];
		$user->user_preference_ids = $c_node['user']['preference'];
		$user->txt_true_self = $lang['txt_true_self'];
		$user->txt_alias = $lang['txt_alias'];
		
		$user->setupUser($frmdata);
		
		//send the invites
		if (!empty($frmdata['to'])) {
			//setup email
			require_once('class/Mail/class.phpmailer.php');
			$mail = new PHPMailer();
			$mail->Host = 		$c_node['mail']['host'];
			$mail->Port = 		$c_node['mail']['port'];
			$mail->Mailer = 	$c_node['mail']['mailer'];
			
			if (isset($c_node['mail']['smtp']['username'])) {
				$mail->SMTPAuth = true;
				$mail->Username = $c_node['mail']['smtp']['username'];
				$mail->Password = $c_node['mail']['smtp']['password'];
			}
				
			//$mail->From = 		$c_node['mail']['no_reply_address'];
			//$mail->FromName = 	$c_node['mail']['from_name'];
			
			$mail->From = 		$output_user['user_email'];
			$mail->FromName = 	$output_user['user_firstname'];
			
			$mail->WordWrap = 	$c_node['mail']['wordwrap'];
			$mail->Subject = 	$lang['txt_invite_message_txt'];
			$mail->AddReplyTo	($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
			$user->mail = $mail;
			
			$user->body_file_mail_txt = readTxtFile($languageTextPath . "mail_invite.txt.php");
			$user->body_file_im_txt = readTxtFile($languageTextPath . "im_invite.txt.php");
		
			$user->txt_invite_message_txt = $lang['txt_invite_message_txt'];
			
	    	$user->userSetupInvites($frmdata);
		}
		
		//setup social network
		$sn->user_id = $frmdata['user_id'];
		$sn_degree1_total = count($sn->selRelations($frmdata['user_id']));
		
		if (empty($sn_degree1_total)) {
			$sn_degree1_total = "0";
		}
		
		$sn->insertSnStatistic(1, $sn_degree1_total, $c_node['batch']['enabled']);
		
	}
	else { //return vars to form
		$display = "account";
	}
	
	if (empty($GLOBALS['igloo_error_log'])) {
	   	$user->relation_type = $c_node['user']['relation_type']['approved'];
		$user->total_login_stat_id = $c_node['statistic']['user']['total_logins'];

		$user->loginUser($output_user['user_email'],$frmdata['user_password1']);
	}
}
elseif (isset($_REQUEST['em'])) { //the account page
	//get user
	$user->user_email = $_REQUEST['em'];
	$frmdata = $user->getUser();
	
	if (isset($frmdata['status_id']) && $frmdata['status_id'] == $c_node['user']['status']['pending']) { //we can set up
		$display = "persona";
	}
	elseif (isset($frmdata['user_id'])) { //we can set up
		$display = "setup_already";
	}
	else{ //you have already setup.
		$display = "hack";
	}
}
elseif (isset($_POST['persona'])) {
	// Check the firstname
	if(empty($frmdata['user_firstname'])) {
		$GLOBALS['igloo_error_log'][] = array(5, null, null);
	}
	
	// Check the surname
	if(empty($frmdata['user_surname'])) {
		$GLOBALS['igloo_error_log'][] = array(6, null, null);
	}
	
	// Check the nic
	if(empty($frmdata['alias_nic'])) {
		$GLOBALS['igloo_error_log'][] = array(7, null, null);
	}
	
	// Check the place of residence
	if(empty($frmdata['user_hometown'])) {
		$GLOBALS['igloo_error_log'][] = array(10, null, null);
	}
	
	// Check the place of residence
	if(empty($frmdata['alias_hometown'])) {
		$GLOBALS['igloo_error_log'][] = array(10, null, null);
	}
	
	if (empty($GLOBALS['igloo_error_log'])) {
		if ($c_node['node']['allow_setup_invites'] == 1) {
			$display = "network";
		}
		else {
			$display = "preferences";
		}
	}
	else {
		$display = "persona";
	}
}
elseif (isset($_POST['network'])) {
	$display = "preferences";
}
elseif (isset($_POST['preferences'])) {
	$display = "account";
}
else { //we error becuase we did not get the right vars passed to the page
	header("Location: index.php");
	exit;
}



//TEMPLATE
if (isset($frmdata)) {
    $body->set('data', $frmdata);
}

if ($c_node['node']['allow_setup_invites'] == 1) {
   $body->set('allow_setup_invites', 1);
}

if (isset($display)) {
    $body->set('display', $display);
}

$body->set('batch_enabled', $c_node['batch']['enabled']);

include "inc/footer.inc.php";

?>

