<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php
			if (isset($newsletter)) {
				echo $this->date->formatDate($newsletter['message_create_datetime'], 1);
			}
			else {
				echo $lang['hdr_newsletters'];
			}
			?>
			<br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($total_emails_sent)) {
				?>
				<p>
					<?php echo $lang['txt_emails_sent'];?><br />
				</p>
	
				<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
				<?php
				}
				?>
				
				<?php
				if (isset($batch_complete)) {
				?>
				<p>
					<b><?php echo $lang['txt_batch_complete'];?></b><br />
				</p>
				
				<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
				<?php
				}
				?>
			
				<?php
				if (isset($newsletter)) {
				?>
				<p class="txt_item_title">
					<?php echo $newsletter['message_subject'];?><br />
				</p>
				
				<p>
				<?php echo $newsletter['message_body'];?><br />
				</p>
				<?php
				}
				elseif (isset($newsletters)) { //list view
				?>
				
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					$display_items = trimArray($newsletters);
					foreach($display_items as $key => $i):
					?>
					<tr>
						<td>
							<a href="nlt_view.php?message_id=<?php echo $i['message_id'];?>"><?php echo $i['message_subject'];?></a><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($i['message_create_datetime']);?><br />
						</td>
						<td>
							<?php echo $lang['newsletter']['status'][$i['status_id']];?><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				echo createArrayList($newsletters);
				?>
				<?php
				}
				else  { //error - no newsletters
					echo $lang['err_no_newsletters'] . "<br />";
				}?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<form action="nlt_view.php" method="post" name="frm_view" id="id_frm_view">
	<input type="hidden" name="message_id" value="<?php if(isset($newsletter['message_id'])) { echo $newsletter['message_id'];}?>" />
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<select name="options" class="options_select">
					<?php
					if (isset($newsletter)) {
					?>
					<option value="list" selected="selected"><?php echo $lang['txt_option_list'];?></option>
					<option value="item_edit"><?php echo $lang['txt_option_edit'];?></option>
					<option> </option>
					<?php }?>
					<option value="item_add"><?php echo $lang['txt_option_add'];?></option>
				</select>
				<input type="image" src="<?php echo $templatePath;?>img/go.png" name="option_action" value="1" class="go" /><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	</form>
</div>
