+++ Customise
Igloo is a highly customisable solution. You can add other interface languages making Igloo idea within a multilingual environment. You can change the interface design by editing the templates. You can add menus and you can customise the user roles and file upload types. The following guide takes you through the settings to configure this. 

Igloo is pre-configured to allow you to start using it direct after completing the  set-up process. You may wish to customise Igloo. There are a number of ways to do this as covered in this section including adding different file types, adding menus and changing the look and feel of your Igloo installation.

[[toc]]

+++ MIME types (file types accepted for upload)
A MIME type is a Multi-purpose Internet Mail Extension (MIME) type. It identifies the format of a file that beacon accepts for upload. It also enables you to identify an application that will read the file. 

##red|WARNING: Allowing people to upload files containing worms, viruses or any malicious code will result in you being responsible for spreading that code to both the server and any user downloading the file. ##

##red|This guide DOES NOT cover any aspect of file management, file testing, monitoring or virus control. Consult a systems administrator before adding any file types especially if those files contain code that can run (macros or scripts). When it comes to worms and viruses never think 'oh I'll get away with it' or 'it won't happen to me' - it will and it hurts.##

Edit the config/config.inc.php file and scroll down to the section marked 'MIME CONFIGURATION'. You will see a 2 line configuration per MIME type:

$c_node['file']['mime'][1]['mime'] = 		"image/jpeg";
$c_node['file']['mime'][1]['suffix'] = 		"jpg";

The [1] must be a unique number. You can add a file type by adding two lines to this list.

++++ Example of adding a MIME type
You want to allow contributors to upload and read MP3 (sound) files to your beacon installation.

Go to your favourite search engine and type in 'MIME type list'. You will soon find a listing of all MIME types available to you. You will find the MP3MIME type listed:

audio/mpeg ' mp3 
In the config file the last item in the MIME configuration list is:
$c_node['file']['mime'][5]['mime'] = 		"text/plain";
$c_node['file']['mime'][5]['suffix'] = 		"txt";

The unique number for the last MIME type is 5, therefore the next available unique number is 6. We can now add the next two lines to the config:

$c_node['file']['mime'][6]['mime'] = 		"audio/mpeg";
$c_node['file']['mime'][6]['suffix'] = 		"mp3";

Your beacon installation will now accept contributor upload of MP3 files. 

++++ Mapping multiple MIME types
sometimes MIME types vary from browser to browser. Igloo can map one MIME type to another. 

Add an array item for each instance of the MIME types you want changing to the config browser MIME type config array.

'''Example'''
You wish to map a MIME type 'image/example' to 'image/png'. Append the array variable with 

$c_node['file']['mime']['browser_path'] = array(array("from" => "image/pjpeg", "to" => "image/jpeg"), array("from" => "image/example", "to" => "image/png"));

++++ Setting up a file type for embedding in a page
Igloo does all the work for you when you add a MIME type. The only thing that is required is for you to make an icon image of the file icon.

++++ Adding an icon to a file type
File icons need to follow a specific naming convention of file_<suffix name>.png . You will need to make a png file as a thumbnail image of the file icon.

'''Example if creating an icon image for a MP3 file:'''

# Go to the template/img/ directory and copy and paste file_txt.png
# Rename your copy to file_mp3.png,
# Open the file an image editing application of your choice (that supports png file formats).
# Navigate to a local MPS file. 
# Screen grab the screen and paste the screen image into your image application.
# Crop the image so that only the MP3 icon is left.
# Copy and paste you MP3 icon over the text icon.
# Save.


++++ SWF file format and formats that require plug-ins.
We are building a set of plug-ins to the Wiki which allow you to embed files such as video and flash into your wiki pages. Flash is available for download and others will follow soon. Please see http://www.barnraiser.org/downloads/ for availability.

+++ Templates
The templating system allows you to simply change the graphical and user interface (look and feel) design of your beacon installation. You may wish to implement your company brand or change a font colour. The templating system allows you to do that easily.

You do need an understanding of HTML (XHTML) and CSS. We recommend that you pick up an introductory book if you are unfamiliar with these standards.

If you are familiar with XHTML and CSS you can edit the template files. Back up your beacon directory then navigate to the template/ directory. In it you will find all template files and images used within the interface.

Igloo has an outer template which contains menus and outer elements (top navigation and logo, side bar and bottom copyLeft statements). The outer template is called default.tpl.php.

An inner template is inserted into the outer template when beacon renders your page. The name of the inner template reflects the name of the page you are on, so http://my_beacon_installation.com/index.php will have a template name of index.tpl.php. 

Embedded in the templates is PHP code. This allows us to insert the data into the template. PHP starts with <?php and ends with ?>. Unless you are very familiar with PHP do not edit anything between a <?php and a ?>.

+++ Menus
We supply two menus as standard (left side menu and bottom menu). You can add a menu by following the steps below. Please see the user guide for information on populating a menu (adding menu items).

# In the config/config.inc.php file add a line to the menus configuration:
// MENU CONFIGURATION -----------------------------------------
$c_node['menu']['menu'][1] = 	1; //side menu
$c_node['menu']['menu'][2] = 	2; //base menu
$c_node['menu']['menu'][3] = 	3; //new example menu
# Name your menu in your language/en_admin.lang.php file:
$lang['arr_menu'][1] = 		"side menu";
$lang['arr_menu'][2] = 		"base menu";
$lang['arr_menu'][3] = 		"new example menu";

Make sure the number [3] is the same in the both the config and language files.
# In the default template copy the code for a menu that is already available. You will see a line at the top of the code:
$menu = $this->menu->selMenu(1);
Change the '1' to match your menu id (in this example '3'.
# Your new menu is now created. Populate it from the administration menu page and you will see menu items appear.

+++ Language
We try to develop beacon in a way that provides a simple interface. As part of that we have chosen a terminology that follows the traditional publishing industry terminology as supposed to the Internet development industry. You with therefore see us describe 'a wiki page' as 'an article'. If translating a generic language pack for release we ask you to follow the same approach.

All language displayed in the beacon interface is stored in two files:

/language/en_common.lang.php
/language/en_admin.lang.php

The 'en_' section of the filename defines the language, in this example 'English'.

If you with to create another language you can dulicate the files and change them to reflect the new language code, for example Swedish:

/language/sv_common.lang.php
/language/sv_admin.lang.php

Open the files and change all the variable values to be your language of choice then save the files. Please note that they should be saved in UTF-8 format.

Open the /language/texts/ directory and change the language of the content of all files included in this directory.

In the config file you will see a Language section:

$c_node['node']['language']['default'] = 	"1"; 
$c_node['node']['language']['pack'][1] = 	array('eng', null, 'en'); 

Make a new language var and place the Barnraiser_id and Aspell language name in the var. Example of adding Swedish:

$c_node['node']['language']['default'] = 	"1"; 
$c_node['node']['language']['pack'][1] = 	array('eng', null, 'en'); 
$c_node['node']['language']['pack'][2] = 	array('swedish', null, 'sv');

Open up the common language file and add the language name:

$lang['language'][1] = 				"English";
$lang['language'][2] = 				"Swedish";

Note: Ensure the array id is the same for both the pack id and the language id ' In the case of the Swedish example, note that both the config and language values use [2].
