<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


//ACS check
if (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['poll'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


//setup poll ---------------------------------------------------------------
require_once('class/Poll.class.php');
$poll = new Poll($db, null);


if (isset($_REQUEST['poll_id'])) {
	$poll->poll_id = $_REQUEST['poll_id'];
}


//SETUP RSP ---------------------------------------------------------
require_once('class/Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['poll']);
$rsp->user_id = $me['user_id'];


// SETUP WIKI ---------------------------------------------------------------
$wiki_path = "lib_view.php?user_id=" . $me['user_id'] . "&page=";
$wiki_new_path = "lib_edit.php?page=";
$wiki_image_base = "get_file.php?file=";

require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);


// SETUP BOOKMARKS ---------------------------------------------------------
require_once('class/Bookmark.class.php');
$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['poll'], $me['user_id']);
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];


//RECEIVE POST AND PROCESS --------------------------------------------------
if (!empty($frmdata)) {
	$frmdata['poll_question'] = htmlspecialchars($frmdata['poll_question']);

	if (isset($frmdata['preview'])) {
		$frmdata['poll_body'] = stripslashes($frmdata['poll_body']);
		$frmdata['poll_question'] = stripslashes($frmdata['poll_question']);
		$frmdata['poll_body_preview'] = $wiki->transform($frmdata['poll_body'], 'Xhtml');
		
		if (!isset($frmdata['rsp_public_featured'])) {
			$frmdata['rsp_public_featured'] = 0;
		}
		
		if (!empty($frmdata['rsp_node'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['node'], 'degree_id' => $frmdata['rsp_node'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		if (!empty($frmdata['rsp_public'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['public'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		$output_poll = $frmdata;
		
		$display = "allow_edit";
	}
	elseif (isset($frmdata['save']) || isset($frmdata['save_go'])) {
		
		if (!empty($frmdata['poll_start_date'])) {
			if (!empty($frmdata['poll_start_time'])) {
				$frmdata['poll_start_datetime'] = $date->formatFormDateTime($frmdata['poll_start_date'], $frmdata['poll_start_time']);
			}
			else {
				$frmdata['poll_start_datetime'] = $date->formatFormDateTime($frmdata['poll_start_date']);
			}
		}
		else {
			$GLOBALS['igloo_error_log'][] = array(38, null, null);
		}
		
		if (!empty($frmdata['poll_end_date'])) {
			if (!empty($frmdata['poll_start_time'])) {
				$frmdata['poll_end_datetime'] = $date->formatFormDateTime($frmdata['poll_end_date'], $frmdata['poll_end_time']);
			}
			else {
				$frmdata['poll_end_datetime'] = $date->formatFormDateTime($frmdata['poll_end_date']);
			}
		}
		else {
			$GLOBALS['igloo_error_log'][] = array(39, null, null);
		}
		
		if (empty($frmdata['poll_question'])) {
			$GLOBALS['igloo_error_log'][] = array(37, null, null);
		}
		
		if (empty($GLOBALS['igloo_error_log'])) {
			//
			if (isset($frmdata['poll_id']) && $frmdata['poll_id'] > 0) {
				$poll->updatePoll($frmdata);
			}
			else { //we insert record
				$poll->user_id = $me['user_id'];
				$poll->insertPoll($frmdata);
			}
					
			if (empty($GLOBALS['igloo_error_log'])) {
				//insert into setup rsp
				$temp['language_id'] = $me['language_id'];
				
				
				$temp['item_id'] = $poll->poll_id;
				//delete all
				$rsp->deleteRspItem($poll->poll_id);
				
				//insert node rsp entry
				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					if (!empty($frmdata['rsp_node_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if ($frmdata['rsp_node'] == "all") {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_node'];
					}
					
					if($c_node['rsp']['node']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					
					if (!empty($frmdata['rsp_public_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if($c_node['rsp']['public']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				// add bookmark tracking
				$bookmark->item_id = $poll->poll_id;
				$bookmark->deleteBookmark();
				if (!empty($frmdata['ins_mark'])) {
					$bookmark->insertBookmark(1);
				}
				
				//setup statistics
				require_once('class/Statistic.class.php');
				$statistic = new Statistic($db, $c_node['rsp']['item_type']['poll'], $date);
				
				$poll->user_id = $me['user_id'];
				$statistic->user_id = $me['user_id'];
				$statistic->section_item_id = $me['user_id'];
				$statistic->statistic_type_id = $c_node['statistic']['user']['total_polls'];
				
				
				$statistic->setStatistic($poll->selPollCount());
				
				
				if (isset($frmdata['save_go'])) {
					header("Location: pol_view.php?poll_id=" . $poll->poll_id . "&". strip_tags(SID));
					exit;
				}
				else {
					header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&". strip_tags(SID));
					exit;
				}
			}
		}
		else { // somehing errored
			$output_poll = $frmdata;
		}
		
		$display = "allow_edit";
		
	}
	elseif (isset($_POST['delete_poll'])) {
		$poll->deletePoll();
		
		header("Location: pol_view.php?list=1&".SID);
		exit;
	}
	elseif (isset($_POST['insert_poll_option'])) {
		$poll->user_id = $me['user_id'];
		$poll->insertOption($frmdata['option_body']);
		
		header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
		exit;
	}
	elseif (isset($_POST['update_poll_option'])) {
		$poll->user_id = $me['user_id'];
		$poll->updateOption($frmdata['option_id'], $frmdata['option_body']);
		
		header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
		exit;
	
	}
	elseif (isset($_POST['delete_poll_option'])) {
		$poll->deleteOption($frmdata['option_id']);
		
		header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
		exit;
	
	}
}
elseif (isset($_REQUEST['poll_id']) && $_REQUEST['poll_id'] > 0) {
	$output_poll = $poll->selPoll();
	$display = "edit_poll";

}
else {
	$display = "add_poll";
}


if (isset($poll->poll_id)) {

	//You can delete before any comments are added or votes are given
	$poll->user_id = $me['user_id'];
	$output_poll_usage = $poll->getUserPollParticipation();
	
	if (isset($_REQUEST['option_id'])) { //we edit an option
		$output_option = $_REQUEST['option_id'];
	}
}


// SETUP LIBRARY ---------------------------------------------------------
require_once('class/Library.class.php');
$library = new Library($db, null);
$output_wikipages = $library->getPages();
$file->user_id = $me['user_id'];
$output_filenames = $file->getFiles();


//format dates
if (isset($output_poll['poll_start_datetime'])) {
	$output_poll['poll_start_date'] = substr($output_poll['poll_start_datetime'], 0,10);
	$output_poll['poll_end_date'] = substr($output_poll['poll_end_datetime'], 0,10);
	$output_poll['poll_start_time'] = substr($output_poll['poll_start_datetime'], 11,15);
	$output_poll['poll_end_time'] = substr($output_poll['poll_end_datetime'], 11,15);
}
else {
	$output_poll['poll_start_date'] = date('Y-m-d');
	$output_poll['poll_end_date'] = date('Y-m-d');
	$output_poll['poll_start_time'] = date('H:i');
	$output_poll['poll_end_time'] = date('H:i');
}


if (isset($output_poll)) {
	//get bookmark
	$bookmark->item_id = $output_poll['poll_id'];
	$output_poll['bookmark'] = $bookmark->getBookmark(1);
}


//RSP items
if (isset($poll->poll_id)) {
	$output_poll['rsp'] = $rsp->selRspItem($poll->poll_id);
}


//move to template
if (!empty($output_wikipages)) {
	$body->set('wikipages', $output_wikipages);
}

if (!empty($output_filenames)) {
	$body->set('filenames', $output_filenames);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_polls)) {
   $body->set('polls', $output_polls);
}

if (!empty($output_poll)) {
   $body->set('poll', $output_poll);
}

if (!empty($output_poll_usage)) {
   $body->set('poll_usage', $output_poll_usage);
}

if (!empty($output_option)) {
   $body->set('option', $output_option);
}

$body->set('languagePath', $languagePath);

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
