/* OS.c, v. 1.7, 2019-01-21 */
/* OS.c, v. 1.6, 2018-01-28 */
/* OS.c, v. 1.5, 2018-01-10 */
/* OS.c, v. 1.4, 2017-11-06 */

/*
 * Copyright (c) 1997-2019 Alexei G. Malinin <Alexei.Malinin@mail.ru>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>

#ifdef WINDOWS
	#include <conio.h>
#else
	#include <termios.h>
#endif

void clear_screen(void) {
#ifdef WINDOWS
	if (system("cls"))
#else
	if (system("clear"))
#endif
		printf("\r\n\r\n\f");
}

#ifndef WINDOWS
static struct termios
	orig_stdin_t, orig_stdout_t, orig_stderr_t,
	stdin_t, stdout_t, stderr_t;
#endif

void get_tty_mode(void) {
#ifndef WINDOWS
	while (tcgetattr(STDIN_FILENO, &stdin_t)==-1)
		if (errno!=EINTR)
			break;
	while (tcgetattr(STDOUT_FILENO, &stdout_t)==-1)
		if (errno!=EINTR)
			break;
	while (tcgetattr(STDERR_FILENO, &stderr_t)==-1)
		if (errno!=EINTR)
			break;

	orig_stdin_t=stdin_t;
	orig_stdout_t=stdout_t;
	orig_stderr_t=stderr_t;
#endif
}

void set_tty_raw_mode(void) {
#ifndef WINDOWS
	cfmakeraw(&stdin_t);
	cfmakeraw(&stdout_t);
	cfmakeraw(&stderr_t);

	while (tcsetattr(STDIN_FILENO, TCSANOW, &stdin_t)==-1)
		if (errno!=EINTR)
			break;
	while (tcsetattr(STDOUT_FILENO, TCSANOW, &stdout_t)==-1)
		if (errno!=EINTR)
			break;
	while (tcsetattr(STDERR_FILENO, TCSANOW, &stderr_t)==-1)
		if (errno!=EINTR)
			break;
#endif
}

void restore_tty_mode(void) {
#ifndef WINDOWS
	while (tcsetattr(STDIN_FILENO, TCSANOW, &orig_stdin_t)==-1)
		if (errno!=EINTR)
			break;
	while (tcsetattr(STDOUT_FILENO, TCSANOW, &orig_stdout_t)==-1)
		if (errno!=EINTR)
			break;
	while (tcsetattr(STDERR_FILENO, TCSANOW, &orig_stderr_t)==-1)
		if (errno!=EINTR)
			break;

	stdin_t=orig_stdin_t;
	stdout_t=orig_stdout_t;
	stderr_t=orig_stderr_t;
#endif
}

int get_ch(void) {
#ifdef WINDOWS
	return (getch());
#else
	return (getchar());
#endif
}


