#! /bin/sh

#
# Copyright (c) 1997-2019 Alexei G. Malinin <Alexei.Malinin@mail.ru>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#


usage() {
	echo "usage:		$0 (fd0|hd0) <test_disk> [LBA|CHS]"
	echo "example 1:	$0 fd0 /dev/rfd0c"
	echo "example 2:	$0 hd0 /dev/rsd3c"
	echo "example 3:	$0 fd0 /dev/rfd0c CHS"
	echo "example 4:	$0 hd0 /dev/rsd3c LBA"
	exit 1
}

if [ $# -lt 2 -o $# -gt 3 ]; then
	usage
fi

TARGET=$1
shift
TEST_DISK=$1
shift

if [ "x$1" != "x" ]; then
	if [ "x$1" = "xCHS" -o "x$1" = "xLBA" ]; then
		iMBR_SUFFIX=.$1
		shift
	else
		usage
	fi
fi

CURRENT_DIR="`pwd`"
TMP_DIR=${CURRENT_DIR}/tmp
DATA_DIR=${CURRENT_DIR}/data
MAIN_DIR=${CURRENT_DIR}/..
OUT_DIR=${CURRENT_DIR}/../OUT

iMBR=${OUT_DIR}/iMBR
EDITOR=${OUT_DIR}/iMBR_editor

MBR_ORIG=${DATA_DIR}/mbr.${TARGET}
MBR_NEW=${TARGET}.mbr
PBR=${TARGET}.pbr
MAKE_PBRS="${CURRENT_DIR}/_PBRs.MAKE.sh ${TARGET}"

MAKE_TEST_DISK=${CURRENT_DIR}/make_test_disk


trap "rm -f ${MBR_NEW} ${PBR}[0-3]" EXIT HUP INT QUIT ABRT TERM


mkdir -p ${TMP_DIR} || exit $?

make && cd ${MAIN_DIR} && make && cd ${CURRENT_DIR} && ${MAKE_PBRS} || exit $?

echo -n "Press Enter... " && read KEY && echo || exit $?

SSS=$(stty -g)
#stty raw
${EDITOR} ${iMBR}${iMBR_SUFFIX} ${MBR_ORIG} ${MBR_NEW} || exit $?
stty "${SSS}"
unset SSS

${MAKE_TEST_DISK} \
	${TEST_DISK} ${MBR_NEW} ${PBR}0 ${PBR}1 ${PBR}2 ${PBR}3 || exit $?

echo
echo "${TEST_DISK} has been written."
echo
echo


