#! /bin/sh

#
# Copyright (c) 1997-2019 Alexei G. Malinin <Alexei.Malinin@mail.ru>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#


if [ $# -eq 1 ]; then
	PREFIX=$1.
	shift
fi

PTE=PTe
PBR=pbr
INVALID_PBR_NUMBER=0

trap "rm -f ${PTE}.S.src" EXIT HUP INT QUIT ABRT TERM

for p in 0 1 2 3; do
	if [ $p -eq ${INVALID_PBR_NUMBER} -a x"${PREFIX}" = x"fd0." ]; then
		cat ${PTE}.S.template | \
		sed "s/.word		BR_SIGNATURE$/.word		0/" \
			>${PTE}.S.src || exit $?
	else
		cat ${PTE}.S.template \
			>${PTE}.S.src || exit $?
	fi
	cat ${PTE}.S.src | sed "s/PT entry: #/PT entry: $p/" >${PTE}.S	&& \
	echo "${PBR}$p: "						&& \
	diff -T -U 0 ${PTE}.S.template ${PTE}.S				|| \
	make pbr >/dev/null 2>&1 &&					\
	mv -f ${PBR} ${PREFIX}${PBR}$p || exit $?
	echo
done

if [ x"${PREFIX}" = x"fd0." ]; then
	echo "${PBR}${INVALID_PBR_NUMBER} has no valid signature."
fi
echo
echo


