/*
   Copyright (C) 2009  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ASTERIX_MESSAGE_DATABASE_HXX
# define ASTERIX_MESSAGE_DATABASE_HXX

# include <intifada/os_wrappers/inttypes.h>			// ?int*_t
# include <string>

// messages de cat�gorie 1/2
#define CAT_001_002_TOTAL_MESSAGES 64
extern std::string cat_001_002_type;
extern size_t cat_001_002_total_messages;
extern uint16_t cat_001_002_message_size [CAT_001_002_TOTAL_MESSAGES];
extern uint8_t cat_001_002_message[CAT_001_002_TOTAL_MESSAGES][1371];

// messages plots mode S
#define MODE_S_TOTAL_MESSAGES 101
extern std::string mode_s_type;
extern size_t mode_s_total_messages;
extern uint16_t mode_s_message_size [MODE_S_TOTAL_MESSAGES];
extern uint8_t mode_s_message[MODE_S_TOTAL_MESSAGES][256];

// messages cat 30 eurocontrol
#define EUROCONTROL_30_TOTAL_MESSAGES 6
extern std::string eurocontrol_30_type;
extern size_t eurocontrol_30_total_messages;
extern uint16_t eurocontrol_30_message_size [EUROCONTROL_30_TOTAL_MESSAGES];
extern uint8_t eurocontrol_30_message[EUROCONTROL_30_TOTAL_MESSAGES][1371];

// messages cat 30 STR-ODS
#define STR_ODS_TOTAL_MESSAGES 1
extern std::string str_ods_type;
extern size_t str_ods_total_messages;
extern uint16_t str_ods_message_size [STR_ODS_TOTAL_MESSAGES];
extern uint8_t str_ods_message[STR_ODS_TOTAL_MESSAGES][1371];

// messages de catégorie 030/032/255 EXSA/IRMA
#define CAT_030_252_APPROACH_TOTAL_MESSAGES 14
extern std::string cat_030_252_approach_type;
extern size_t cat_030_252_approach_total_messages;
extern uint16_t cat_030_252_approach_message_size [CAT_030_252_APPROACH_TOTAL_MESSAGES];
extern uint8_t cat_030_252_approach_message[CAT_030_252_APPROACH_TOTAL_MESSAGES][1371];

// messages de cat 65/67
#define CAT_062_065_TOTAL_MESSAGES
extern std::string cat_062_065_type;
extern size_t cat_062_065_total_messages;
extern uint16_t cat_062_065_size [CAT_062_065_TOTAL_MESSAGES];
extern uint8_t cat_062_065[CAT_062_065_TOTAL_MESSAGES][288];



/* 70 bytes
{ // 0
                0x1E,
                0x00,0x46,            // 70
                0xBF,                 // fspec 1011111 (1) 010/030/035/040/070/170
                0xFF,                 // fspec 1111111 (1) 100/180/181/060/150/130/160
                0x80,                 // fspec 0000100 (0) 240
                0x08, 0x82,           // 010
                0x50,                 // 030
                0x01,                 // 035
                0x3C, 0x64,           // 040
                0x08, 0x6E, 0x09,     // 070
                0x4E, 0x0E,           // 170
                0x00, 0x47,           // 170
                0x3D, 0xFE,           // 100
                0x30, 0x00,           // 100
                0x00, 0x5F,           // 180
                0x00, 0x6C,           // 180
                0xFF, 0xD5,           // 181
                0xFF, 0x4C,           // 181
                0xF8, 0xFF,           // 060
                0x15, 0x0F,           // 150
                0x0D, 0x04,           // 130
                0x28, 0x21,           // 160
                0x3F,                 // 240
                0xFE,                 // fspec 1111111 (0) 010/015/030/035/040/070/170
                0x50, 0x05,           // 010
                0x98, 0x64,           // 015
                0x08,                 // 030
                0x6E,                 // 035
                0x01, 0x4E,           // 040
                0x0B, 0xC9, 0x47,     // 070
                0x3A, 0xFC,           // 170
                0x86, 0x0E,           // 170
                0x03,                 // fspec 0000011 (1) 070/170
                0xA6,                 // fspec 1010011 (0) 100/181/130/160
                0x03, 0xA0, 0x06,     // 070
                0x6D, 0x03,           // 170
                0xC2, 0xF4,           // 170
                0x01, 0x70,           // 100
                0x25, 0x01,           // 100
                0x34            // 181 (1/4)
              },
              */




#endif // ASTERIX_MESSAGE_DATABASE_H
