#
#  Copyright (C) 2009  Stephane Pion
#  This file is part of Intifada.
#
#   Intifada is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Intifada is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
#


AC_DEFUN([INTIFADA_BUILD_CONFIGURATION_H],
[
# ----------------------------------------------------------------------
# Add code to config.status to create an installable host dependent
# configuration file indicating if inlining functions was used during
# compilation.
# ----------------------------------------------------------------------
AC_CONFIG_COMMANDS([intifada/build_configuration.h],[
	outfile=intifada/build_configuration.h
	stampfile=intifada/stamp-build_configuration
	tmpfile=${outfile}T
	
	echo creating $outfile
	cat > $tmpfile << _EOF_
/*  -*- Mode: C -*-
 * --------------------------------------------------------------------
 * DO NOT EDIT THIS FILE!  It has been automatically generated
 * from:    configure.ac on host: `(hostname || uname -n) 2>/dev/null | sed 1q`
 * --------------------------------------------------------------------
 */

#ifndef INTIFADA_BUILD_CONFIGURATION_H
#define INTIFADA_BUILD_CONFIGURATION_H 1

_EOF_

	if test x$intifada_inline = xyes; then
		echo "#define INTIFADA_INLINE inline" >> $tmpfile
		echo "#define INTIFADA_USE_INLINE" >> $tmpfile
	else
		echo "#define INTIFADA_INLINE" >> $tmpfile
	fi

cat >> $tmpfile << _EOF_

#define INTIFADA_INLINE_HXX(X) 

#endif /* INTIFADA_BUILD_CONFIGURATION_H */

_EOF_

# replace file only if contents are differents
	cmp $tmpfile $outfile >/dev/null 2>&1 || cp $tmpfile $outfile
	rm $tmpfile
],[
	intifada_inline=$intifada_inline
])
])