/*
   Copyright (C) 2009, 2010  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <Dump_Iterator.hxx>
#include <iostream>
#include <intifada/Record.hxx>

Dump_Iterator::Dump_Iterator():it_(){}

void Dump_Iterator::dump_all()
  {
    it_.dump_all();
  }
/// Called when a block began
int Dump_Iterator::operator()(uint8_t c)
                                                {
    std::cout << "cat=" << (uint32_t) c << std::endl;
    return 0;
                                                }

int Dump_Iterator::operator()(
    intifada::Record_Iterator::record_type& i,
    const intifada::Message::block_list_size_t& b,
    const intifada::Block::record_list_size_t& r)
                                {
    std::cout << "\tblock=" << b << " record=" << r << std::endl;
    i.foreach(it_,intifada::Path_Name());
    return 0;
                                }
