/*
   Copyright (C) 2009,2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INTIFADA_INTEGER_T_HXX
# define INTIFADA_INTEGER_T_HXX

#include <intifada/Type.hxx>

namespace intifada
{

  template <typename T_>
  class Integer_T : public intifada::Type
  {
  private:
    typedef intifada::Type inherited;

  public:
    typedef T_ value_type;

    Integer_T();
    Integer_T(T_ i);

    /// Copy constructor
    Integer_T(const Integer_T&rhs);

    /// Copy operator
    Integer_T& operator=(const Integer_T&rhs);

    /// Set this to null value
    /**
     * set a value's instance to null (eg 0 for a numeric type, "" for a string type ...)
     */
    virtual void set_null();

    /// handle changed state
    /**
     * changed states could be detected. This method should be called to
     * indicate which value to remember
     */
    virtual void reset_changed_state();

    /// handle changed state
    /**
     * \return true if current value differs from value when reset_changed_state were called
     * \return false if current value doesn't differ from value when reset_changed_state were called
     */
    virtual bool is_changed_state()const;


    /// Get size
    /**
     * \return size object (unit is the bit)
     */
    virtual ssize_t get_size()const;

    /// Compare with a string
    virtual bool operator==(const std::string& rhs)const;

  private:

    /// adapt stream to internal data
    /**
     * before setting internal data from stream, this method
     * is called with raw stream extracted. This could be used by sub classes
     * to do anything particular
     *
     * \param v data coming from stream
     * \param size size in bits extracted from stream
     * \return v by default
     *
     * inherited new method must adapt the returned value
     */
    virtual T_ stream_to_internal(const T_&v,int size)const;

    /// adapt internal data to stream
    /**
     * above symetric
     * \param v data coming from internal
     * \param size size in bits that will be inserted in stream
     * \return v by default
     *
     * inherited new method must adapt the returned value
     */
    virtual T_ internal_to_stream(const T_&v,int size)const;

  public:

#if 0
    // Equality operator
    Integer_T& operator=(const T_&rhs);
#endif

    /// Get internal value to string
    /**
     * \return internal value
     */
    virtual std::string get_to_string()const;

    /// Set internal value from string
    /**
     * \param v value
     * \return 0 if no error
     */
    virtual int set_from_string(const std::string& v);

    /// Transfert a stream into a real type
    /**
     * \param b stream to transfert
     * \param start begining of transfert (lsb start with 1)
     * \param size size of the transfert
     * \exception std::out_of_range
     */
    virtual void set_from_stream(Stream::const_reverse_iterator b,int start,int size);

    /// Transfert a real type into a stream
    /**
     * \param b target stream
     * \param start begining of transfert (lsb start with 1)
     * \param size size of the transfert
     * \exception std::out_of_range
     */
    virtual void to_stream(Stream::reverse_iterator b,int start,int size)const;

    bool operator==(const T_& rhs)const;

    bool operator!=(const T_& rhs)const;

    T_& operator=(const T_& rhs);

    operator T_()const;

    Integer_T& operator+=(const T_& rhs);

    Integer_T& operator-=(const T_& rhs);

    Integer_T& operator*=(const T_& rhs);

    Integer_T& operator/=(const T_& rhs);
  private:
    T_ value_;
    T_ base_value_;
  };
}

#include <intifada/Integer_T.cxx>


#endif // INTIFADA_INTEGER_T_HXX
