#
#  Copyright (C) 2009  Stephane Pion
#  This file is part of Intifada.
#
#   Intifada is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Intifada is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
#

AC_DEFUN([INTIFADA_INTTYPES_H],
[
# ----------------------------------------------------------------------
# Add code to config.status to create an installable host dependent
# configuration file.
# ----------------------------------------------------------------------
AC_CONFIG_COMMANDS([intifada/os_wrappers/inttypes.h],[

	outfile=intifada/os_wrappers/inttypes.h
	stampfile=intifada/os_wrappers/stamp-inttypes
	tmpfile=${outfile}T
	
	echo creating $outfile
	cat > $tmpfile << _EOF_
/*  -*- Mode: C -*-
 * --------------------------------------------------------------------
 * DO NOT EDIT THIS FILE!  It has been automatically generated
 * from:    configure.ac on host: `(hostname || uname -n) 2>/dev/null | sed 1q`
 * --------------------------------------------------------------------
 */

#ifndef INTIFADA_OS_WRAPPERS_INTTYPES_H
#define INTIFADA_OS_WRAPPERS_INTTYPES_H 1

_EOF_

	if test x$ac_cv_header_inttypes_h = xyes; then
		echo '#include <inttypes.h>' >> $tmpfile
	fi
	if test x$ac_cv_header_stdint_h = xyes; then
		echo '#include <stdint.h>' >> $tmpfile
	fi
	cat >> $tmpfile << _EOF_
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
_EOF_
	if test x$ac_cv_type_int8_t != xyes; then echo "typedef $intifada_1_byte int8_t;" >> $tmpfile ; fi
	if test x$ac_cv_type_int16_t != xyes; then echo "typedef $intifada_2_byte int16_t;" >> $tmpfile ; fi
	if test x$ac_cv_type_int32_t != xyes; then echo "typedef $intifada_4_byte int32_t;" >> $tmpfile ; fi
	if test x$ac_cv_type_int64_t != xyes; then echo "typedef $intifada_8_byte int64_t;" >> $tmpfile ; fi
	
	if test x$ac_cv_type_uint8_t != xyes; then echo "typedef $intifada_1_ubyte uint8_t;" >> $tmpfile ; fi
	if test x$ac_cv_type_uint16_t != xyes; then echo "typedef $intifada_2_ubyte uint16_t;" >> $tmpfile ; fi
	if test x$ac_cv_type_uint32_t != xyes; then echo "typedef $intifada_4_ubyte uint32_t;" >> $tmpfile ; fi
	if test x$ac_cv_type_uint64_t != xyes; then echo "typedef $intifada_8_ubyte uint64_t;" >> $tmpfile ; fi

	cat >> $tmpfile << _EOF_
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* INTIFADA_OS_WRAPPERS_INTTYPES_H */

_EOF_

	# replace file only if contents are differents
	cmp $tmpfile $outfile >/dev/null 2>&1 || ( cp $tmpfile $outfile ; echo timestamp > $stampfile )
	rm $tmpfile
	
],[
  	ac_cv_header_inttypes_h="$ac_cv_header_inttypes_h"
	ac_cv_header_stdint_h="$ac_cv_header_stdint_h"
	intifada_1_byte="$intifada_1_byte"
	intifada_2_byte="$intifada_2_byte"
	intifada_4_byte="$intifada_4_byte"
	intifada_8_byte="$intifada_8_byte"
	intifada_1_ubyte="$intifada_1_ubyte"
	intifada_2_ubyte="$intifada_2_ubyte"
	intifada_4_ubyte="$intifada_4_ubyte"
	intifada_8_ubyte="$intifada_8_ubyte"

	ac_cv_type_int8_t="$ac_cv_type_int8_t"
	ac_cv_type_int16_t="$ac_cv_type_int16_t"
	ac_cv_type_int32_t="$ac_cv_type_int32_t"
	ac_cv_type_int64_t="$ac_cv_type_int64_t"
	ac_cv_type_uint8_t="$ac_cv_type_uint8_t"
	ac_cv_type_uint16_t="$ac_cv_type_uint16_t"
	ac_cv_type_uint32_t="$ac_cv_type_uint32_t"
	ac_cv_type_uint64_t="$ac_cv_type_uint64_t"
	
])
])
