#
#  Copyright (C) 2011  Stephane Pion
#  This file is part of Intifada.
#
#   Intifada is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Intifada is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
#

AC_DEFUN([INTIFADA_WIRESHARK_CONFIGURATION],
[
PKG_CHECK_MODULES([INTIFADA_GMODULE],[gmodule-2.0],,disable_wireshark=yes)
# Check for wireshark includes presence
AC_ARG_VAR([WIRESHARK_CPPFLAGS],[processor compiler flags for wireshark])
AC_ARG_VAR([WIRESHARK_PLUGINS],[plugin directory installation for wireshark])
AC_SUBST([WIRESHARK_CPPFLAGS])
AC_SUBST([WIRESHARK_PLUGINS])
if test "x${ac_env_WIRESHARK_CPPFLAGS_set}" != xset; then
	WIRESHARK_CPPFLAGS="-I/usr/include/wireshark"
fi
if test "x${ac_env_WIRESHARK_PLUGINS_set}" != xset; then
	WIRESHARK_PLUGINS="${prefix}/lib/wireshark/plugins"
fi

SAVED_CPPFLAGS=$CPPFLAGS
CPPFLAGS="$CPPFLAGS $WIRESHARK_CPPFLAGS $INTIFADA_GMODULE_CFLAGS $WIRESHARK_PLUGIN_CFLAGS"
AC_LANG_PUSH([C])
AC_CHECK_HEADERS([epan/value_string.h epan/uat.h epan/packet_info.h epan/proto.h epan/packet.h epan/tvbuff.h epan/emem.h epan/report_err.h],,[disable_wireshark=yes],
[
#include <wireshark/config.h>
#include <epan/prefs.h>
])
if test "x${disable_wireshark}" != xyes; then
	AC_CHECK_TYPE([uat_post_update_cb_t],,,[
#include <wireshark/config.h>
#include <epan/prefs.h>
#include <epan/uat.h>
])
	AC_MSG_CHECKING([if UAT_FLD_VS have 5 args])
	AC_PREPROC_IFELSE(
        [AC_LANG_PROGRAM([[#include <wireshark/config.h>
#include <epan/prefs.h>
#include <epan/uat.h>]],
                         [[UAT_FLD_VS(1,2,3,4,5)]])],[AC_MSG_RESULT([yes])
                         								uat_fld_vs_args=5],[AC_MSG_RESULT([no])])
	AC_MSG_CHECKING([if UAT_FLD_VS have 4 args])
	AC_PREPROC_IFELSE(
        [AC_LANG_PROGRAM([[#include <wireshark/config.h>
#include <epan/prefs.h>
#include <epan/uat.h>]],
                         [[UAT_FLD_VS(1,2,3,4)]])],[AC_MSG_RESULT([yes])
                         								uat_fld_vs_args=4],[AC_MSG_RESULT([no])])
    AC_MSG_CHECKING([if UAT_FLD_CSTRING_ISPRINT have 4 args])
	AC_PREPROC_IFELSE(
        [AC_LANG_PROGRAM([[#include <wireshark/config.h>
#include <epan/prefs.h>
#include <epan/uat.h>]],
                         [[UAT_FLD_CSTRING_ISPRINT(1,2,3,4)]])],[AC_MSG_RESULT([yes])
                         								uat_fld_cstring_isprint_args=4],[AC_MSG_RESULT([no])])
	AC_MSG_CHECKING([if UAT_FLD_CSTRING_ISPRINT have 3 args])
	AC_PREPROC_IFELSE(
        [AC_LANG_PROGRAM([[#include <wireshark/config.h>
#include <epan/prefs.h>
#include <epan/uat.h>]],
                         [[UAT_FLD_CSTRING_ISPRINT(1,2,3)]])],[AC_MSG_RESULT([yes])
                         								uat_fld_cstring_isprint_args=3],[AC_MSG_RESULT([no])])
    
fi
AM_CONDITIONAL([INTIFADA_HAVE_WIRESHARK],[test "x$disable_wireshark" != xyes])
AC_LANG_POP([C])
CPPFLAGS=$SAVED_CPPFLAGS

])
