/*
   Copyright (C) 2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <intifada_wrapper.h>

#include <intifada/Configuration_XML_Reader.hxx>
#include <intifada/Path_Configuration.hxx>
#include <intifada/Record_Repository.hxx>
#include <intifada/Record_Iterator_List.hxx>
#include <intifada/Message.hxx>
#include <Dump_Iterator.hxx>
#include <prefs.h>
#include <iostream>
static intifada::Record_Repository* ast_repository=NULL;

void get_factory_description(const char **desc)
{
  std::string d = intifada::Path_Configuration::instance()->get_factory_description();
  *desc=g_strdup(d.c_str());
  return;
}

int init_xml_asterix(const char* desc)
{
  int ret=0;
  if(is_debug()==TRUE)printf("init_xml_asterix:desc=<%s>\n",desc);
  intifada::Configuration_XML_Reader p(desc);
  int opened=p.open();
  if(opened==0)
    {
      if(ast_repository!=NULL)
	{
	  ast_repository->release();
	}
      ast_repository=intifada::Record_Repository::instance();
      p.parse(ast_repository);
    }
  else
    {
      ret=FILE_ERROR;
    }
  return ret;
	
}

void asterix_families_update(value_string** asterix_families)
{
  // get known families from asterix library
  intifada::Record_Repository::family_list_t f;
  if(ast_repository!=NULL)
    {
      ast_repository->get_families(f);
    }
  int fam_id=0;
  value_string *vs=*asterix_families;
  if(vs!=NULL)
    {
      for(int i=0;vs[i].strptr;i++) {
	g_free(const_cast<gchar*>(vs[i].strptr));
      }
      delete[] vs;

    }
  *asterix_families=new value_string[f.size()+1];
  vs=*asterix_families;
  if(is_debug()==TRUE)//printf("asterix_families_update:create families(size=%lu):0x%x\n",static_cast<long unsigned>(f.size()),vs);
  	  std::cout << "asterix_families_update:create families(size="<<f.size()<<"):0x"<<vs<<std::endl;
  for(intifada::Record_Repository::family_list_const_iterator_t it = f.begin();it!=f.end();++it)
    {
      if(is_debug()==TRUE)printf("asterix_families_update:family id:%d, family name:%s\n",fam_id,(*it).c_str());
      vs[fam_id].value=fam_id;
      vs[fam_id].strptr=g_strdup((*it).c_str());
      ++fam_id;
    }
  vs[fam_id].value=0;
  vs[fam_id].strptr=NULL;
  return;
}

int asterix_decode(const char*f,const uint8_t *s, size_t o, size_t m,proto_tree *network_tree,const tvbuff_t *tvb,int *index)
{
  Dump_Iterator dit(network_tree,const_cast<tvbuff_t *>(tvb),*index);

  if(is_dump_all()==TRUE)
    {
      dit.dump_all();
    }

  try
    {
      intifada::Message msg(ast_repository,f);
      msg.set_stream(s,o,m);
      intifada::Record_Iterator_List ril;
      ril.register_iterator(dit);
      msg.foreach(ril);
    }
  catch(intifada::Parsing_Input_Length_Exception& ex)
    {
      std::ostringstream err;
      err << "Error dissecting Asterix Message:Invalid size:";
      err << ex.get_expected();
      err << " bytes waited, got ";
      err << ex.get_received();
      err << " bytes";
      dit.error(err.str());
    }
  catch(intifada::Parsing_Unknow_Category& ex)
    {
      std::ostringstream err;
      err << "Error dissecting Asterix Message:Invalid category (";
      err << static_cast<int>(ex.get_category()) << ") for ";
      err << ex.get_family() << " family";
      dit.error(err.str());
    }
  catch(...)
    {
      std::ostringstream err;
      err << "Error dissecting Asterix Message:Unexpected error";
      dit.error(err.str());
    }
  return 0;
}
