#include <tree.h>

static int hf_asterix_target = -1;
static int hf_asterix_source=-1;
static int hf_asterix_ssap=-1;
static int hf_asterix_dsap=-1;



static hf_register_info hfnetwork[] = {
  { &hf_asterix_target,
    { "Target", "asterix.dst",FT_ETHER,BASE_NONE,NULL, 0x0,"Asterix Hardware Destination", HFILL }
		
  },
  { &hf_asterix_source,
    { "Source", "asterix.src",FT_ETHER,BASE_NONE,NULL, 0x0,"Asterix Hardware Source", HFILL }
  },
  { &hf_asterix_ssap,
    { "SSAP", "asterix.ssap",FT_UINT8,BASE_HEX,NULL, 0x0,"Asterix Source Service Access Point", HFILL }
  },
  { &hf_asterix_dsap,
    { "DSAP", "asterix.dsap",FT_UINT8,BASE_HEX,NULL, 0x0,"Asterix Destination Service Access Point", HFILL }
  }
};

static int ett_asterix_network=-1;

/* Setup network subtree array */
static gint *ett[] = {
  &ett_asterix_network
};

static int ett_asterix=-1;
static gint *ett2[] = {
  &ett_asterix
};

hf_register_info* get_network_tree_structure()
{
    return hfnetwork;
}

size_t get_network_tree_structure_size()
{
    return array_length(hfnetwork);
}

proto_tree* get_network_subtree(proto_tree *tree,int proto,const tvbuff_t *tvb)
{
    proto_item *network_ti = proto_tree_add_item(tree, proto, (tvbuff_t *)tvb, 0,-1, FALSE);
    return proto_item_add_subtree(network_ti, ett_asterix_network);
}

int update_network_tree(proto_tree *network_tree,const tvbuff_t *tvb)
{
    int offset=0;
    proto_tree_add_item(network_tree, hf_asterix_target, (tvbuff_t *)tvb, 0, 6, FALSE);
    offset+=6;
    proto_tree_add_item(network_tree, hf_asterix_source, (tvbuff_t *)tvb, 6, 6, FALSE);
    offset+=6;
    proto_tree_add_item(network_tree, hf_asterix_ssap,(tvbuff_t *)tvb,14,1,FALSE);
    offset+=1;
    proto_tree_add_item(network_tree, hf_asterix_dsap,(tvbuff_t *)tvb,15,1,FALSE);
    offset+=1;
    return offset;
}

void register_network_subtree_array()
{
    proto_register_subtree_array(ett, array_length(ett));
}

void register_asterix_subtree_array()
{
    proto_register_subtree_array(ett2, array_length(ett2));
}

int* get_asterix_subtree_index()
{
    return &ett_asterix;
}
