/*
   Copyright (C) 2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ASTERIX_UTILS_H
# define ASTERIX_UTILS_H

# ifdef HAVE_CONFIG_H
#  include <wireshark/config.h>
# endif

# ifdef __cplusplus
extern "C" {
# endif

# include <epan/tvbuff.h>
# include <prefs.h>

extern gboolean match_macaddr(gchar** family,tvbuff_t *tvb);
extern gboolean match_udp(gchar** f,guint32 port);

extern void push_udp_port(const guint32 pattern);
extern gboolean udp_empty();
extern guint32 pop_udp_port();

#ifdef __cplusplus
}
#endif

#endif /* ASTERIX_UTILS_H */
