/* misc.c -- functions used by contact_list/uconfig
   Copyright (C) 2004 Julio A. Becerra

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#define _POSIX_SOURCE
#define _ISOC99_SOURCE
#define _XOPEN_SOURCE		/* TODO we should not need this... */
#define _XOPEN_SOURCE_EXTENDED	/* ... bug in GNU libc6? */

#include <ctype.h>  
#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include "user_iface.h"
#include "common.h"
#include "misc.h"


#define BUF_SIZE 512

char *
home_path (char *file)
{
	struct passwd *pass;
	size_t size;
	char *buf;
	
	pass = getpwuid (getuid());
	CHECK (pass != NULL);
				
	size = strlen (pass->pw_dir);
	buf = malloc ((size + strlen (file) + 2) * sizeof (char));
	CHECK (buf != NULL);

	strcpy (buf, pass->pw_dir);
	
	buf [size] = '/';
	buf [size + 1] = '\0';

	strcat (buf, file);

	return buf;

error:
	return NULL;
}
	
int
check_dir ()
{
	struct stat str;
	char *dir;	
	int ret;
	
	dir = home_path (".ipchat");
	CHECK_J (dir != NULL, error_r);
	
	if (stat (dir, &str) == 0) {
		if (S_ISDIR (str.st_mode)) {
			if (str.st_uid != getuid())
				ui_output_info ("Check %s owner.", dir);

			else if (str.st_mode & S_IRWXG & S_IRWXO)
				ui_output_info ("Insecure %s permissions", dir);
		}

		else {
			ui_output_err ("%s is not a directory.", dir);
			return ERR;
		}
	}
	
	else if (errno == ENOENT) {
		ret = mkdir (dir, S_IRUSR | S_IWUSR | S_IXUSR);
		if (ret != 0) {
			ui_output_err ("Cannot create %s", dir);
			return ERR;
		}
		ui_output_info ("%s created.", dir);
	}
	
	else
		CHECK (errno != EACCES);
	
	free (dir);
	return OK;
	
error:
	free (dir);
error_r:		
	return ERR;
}
	

int 
read_tag (int fd, char *src, char *name, char *buff, size_t size)
{
	char *b;
	int i=0, j=0, k=0, t=0, c=0, nk=0, cl=0, s=0, w=0, co=0;
	ssize_t r;
	size_t name_l;
	int ret=0;

	name_l = strlen (name);
	
	if (src == NULL) {
		b = malloc (BUF_SIZE * sizeof (char));
		if (b == NULL) 
			return ERR;
		r=read (fd, b, BUF_SIZE);
		CHECK (r != -1);
	}
	else {
		b = src;
		r = strlen (src);
	}
	
	do {
		while (i < r)  {
			if (b [i] == '{' && !c) {
				nk++;
				if (nk > 1 && name_l == k && j < size) {
					buff [j] = '{';
					j++;
					ret++;
				}
			}
			else if (b [i] == '}' && !c) {
				t=0;
				s=0;
				if (nk > 0)
					nk--;
				if (name_l == k)  {
					if (nk > 0) {
						if (j < size) {
							buff [j] = '}';
							j++;
						}
					}
					else {
						if (src == NULL) {
							t = i-r+1;
							free (b);
							lseek (fd, t, SEEK_CUR);
						}
						if (j >= size) 
							return ERR_SIZE;
						
						buff [j] = '\0';	
						if (ret!=0 ) {
							if (w!=ret)
								ret = ERR_FMT;
							else if (co)
								ret = ERR_CO;
						}
						return ret;
					}
				}
				else
					k=0;
			}
			else if (nk > 0) {
				if (name_l == k && j < size) {
					if (isspace (b[i]) && !c) {
						s=0;
					}
					else if (nk > 1 || b[i] != '"' || cl) {
						buff [j] = b[i];
						j++;

						if (nk == 1) 
							if (s == 0) {
								w++;
								s = 1;
							}
					}
				}
										
				if (b[i] == '"') {
					if (nk == 1) 
						co = 1;
					c=!c;
					cl=1;
				}
				else
					cl=0;
			}
			else if (isspace ((int) b[i])) {
				t=0;
				if (name_l != k) {	
					k = 0; 
				}
			}
			else {
				if (k == name_l)
					k=0;
			
				if (name[k] == b[i] && !t) {
					k++;
					if (k == name_l)
						t=1;
				}	
				 
				else {
					t=1; 
					k=0;
				}
			}
			i++;		
		}
		
		if (src != NULL)
			r=0;
		else {
			r = read (fd, b, BUF_SIZE);
			CHECK (r != -1);
			i=0;
		}
		
	} while (r);

	if (src == NULL)
		free (b);
	
	return ERR_TAG;

error:
	free (b);
	return ERR;	
}


int 
write_tag (int fd, char *name, char *buff, size_t tabs)
{
	ssize_t r;
	int i = 0, j = 0, c = 0, d = 0;
	size_t s=0;
	char *b, *t;
	char str[] = "{\n";
	char str2[] = " { ";
	char str3[] = " }\n";
	char str4[] = "\"";
	char str6[] = "}\n\n";	
	char str7[] = "\n";
	
	t = malloc ((tabs + 1) * sizeof (char));
	if (t == NULL)
		return ERR;
	
	while (i < tabs) {
		t [i] = '\t';
		i++;
	}
	t [i] = '\0';
			
	if (name != NULL) {
		s = strlen (name) + tabs + 1;

		if (buff == NULL) {
			s += strlen (str7) + tabs + strlen (str);	
			b = malloc (s * sizeof (char));
			if (b == NULL) {
				free (t);
				return ERR;
			}
			strcpy (b, t);
			strcat (b, name);
			strcat (b, str7);
			strcat (b, t);
			strcat (b, str);
		}
		else {	
			s+=strlen (str2) + strlen (str3) + 2*strlen (buff) + 2;
			b = malloc (s * sizeof (char));
			if (b == NULL) {
				free (t);
				return ERR;
			}
			
			i = 0;
			while (buff [i] != '\0')
			{
				if (buff [i]=='{' || buff [i]=='}' || 
				    buff [i]==' ')
					c = 1;

				else if (buff [i] == '"')
					d = 1;
				
				i++;	
			}
	
			strcpy (b, t);
			strcat (b, name);
			strcat (b, str2);
	
			if (c) 
				strcat (b, str4);
	
			if (d) {
				i = 0;
				j = strlen (b);
				while (buff [i] != '\0') {
					if (buff [i] == '"') {
						b[j] = '"';
						j++;
						b[j] = '"';
						j++;
					}
					else {
						b[j] = buff [i];
						j++;
					}
					
					i++;
				}
				b [j] = '\0';
			}

			else 
				strcat (b, buff);
				
			if (c)
				strcat (b, str4);
						
			strcat (b, str3);
		}
	}
	else {
		s = strlen (str6) + tabs + 1;
		b = malloc (s * sizeof (char));
		if (b == NULL) {
			free (t);
			return ERR;
		}
		strcpy (b, t);
		strcat (b, str6); 
	}
	
	r = write (fd, b, strlen (b));
	if (r != strlen (b)) {
		free (b);
		return ERR;
	}
	
	free (b);	
	return OK;
}

