/* common.h -- common definitions
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef COMMON_H
#define COMMON_H 1

/* #include <netinet/in.h> */	/* in_addr_t, in_port_t (TODO is standard?) */
#include <inttypes.h>

#define MAX_NICK 16                     /* 15 (+ '\0') */

typedef uint8_t   BOOL;

#undef TRUE
#define TRUE 1

#undef FALSE
#define FALSE 0

typedef uint8_t   BYTE;
typedef int       sock_t;
typedef uint32_t  ip_t;
typedef uint16_t  port_t;

typedef uint16_t  len_t;	/* type used to send length of message */
#define LEN_T_HTON htons	/* funcs to convert from host to network... */
#define LEN_T_NTOH ntohs        /* ...and from network to host order */

#undef MAX
#undef MIN
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define MIN(a,b) ((a) < (b) ? (a) : (b))

#undef OK			/* we use the same OK and ERR as curses */
#undef ERR			/* TODO that's not very good, is it? */

/* Error codes */
#define OK            (0)	/* No error */
#define ERR          (-1)	/* Generic error */
#define ERR_OPEN     (-2)	/* Error opening file */
#define ERR_IO       (-3)	/* Error in input/output */

#define ERR_LOCAL (-1000)	/* From this, reserved for one-module ERR_'s */

/* Exception simulation */
#define CHECK_J(x,j) do { if (!(x)) goto j; } while (0)
#define CHECK(x) CHECK_J (x, error)
#define CHECK_OK(x) CHECK ((x) == OK)
#define CHECK_OK_J(x,j) CHECK_J (((x) == OK),j)

#endif
