/* contact_list.h -- manages the list of contacts
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef CONTACT_LIST_H
#define CONTACT_LIST_H 1

#include "common.h"
#include "contact.h"

extern contact_t *contacts;

extern int cl_load ();
extern int cl_save ();
extern contact_t* cl_find_by_nick (const char *nick);
extern contact_t* cl_find_by_ip (ip_t ip);
extern void cl_add_contact (contact_t * contact);
extern void cl_remove_contact (const char *nick);

#endif
